/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.client.simple.session;

import java.util.function.Consumer;
import org.apache.commons.codec.binary.Base64;
import org.hswebframework.web.BusinessException;
import org.hswebframework.web.authorization.oauth2.client.AccessTokenInfo;
import org.hswebframework.web.authorization.oauth2.client.OAuth2RequestBuilderFactory;
import org.hswebframework.web.authorization.oauth2.client.OAuth2ServerConfig;
import org.hswebframework.web.authorization.oauth2.client.exception.OAuth2RequestException;
import org.hswebframework.web.authorization.oauth2.client.request.OAuth2Request;
import org.hswebframework.web.authorization.oauth2.client.request.OAuth2Session;
import org.hswebframework.web.authorization.oauth2.client.response.OAuth2Response;
import org.hswebframework.web.oauth2.core.ErrorType;
import org.springframework.util.Assert;

public class DefaultOAuth2Session
implements OAuth2Session {
    protected OAuth2RequestBuilderFactory requestBuilderFactory;
    protected OAuth2ServerConfig serverConfig;
    protected boolean closed = false;
    protected OAuth2Request accessTokenRequest;
    protected AccessTokenInfo accessTokenInfo;
    protected String scope = "";
    private Consumer<AccessTokenInfo> onTokenChange;

    public void setRequestBuilderFactory(OAuth2RequestBuilderFactory requestBuilderFactory) {
        this.requestBuilderFactory = requestBuilderFactory;
    }

    public void setServerConfig(OAuth2ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void init() {
        Assert.notNull((Object)this.requestBuilderFactory, (String)"requestBuilderFactory can not be null!");
        Assert.notNull((Object)this.serverConfig, (String)"configEntity can not be null!");
        this.accessTokenRequest = this.createRequest(this.serverConfig.getAccessTokenUrl());
        this.applyBasicAuthParam(this.accessTokenRequest);
    }

    protected OAuth2Request createRequest(String uriOrUrl) {
        return this.requestBuilderFactory.create(this.serverConfig.getId(), this.serverConfig.getProvider()).url(this.getRealUrl(uriOrUrl)).build();
    }

    public void onTokenChanged(Consumer<AccessTokenInfo> changed) {
        this.onTokenChange = changed;
    }

    protected String encodeAuthorization(String auth) {
        return "basic ".concat(Base64.encodeBase64String((byte[])auth.getBytes()));
    }

    protected void applyBasicAuthParam(OAuth2Request request) {
        request.param("client_id", this.serverConfig.getClientId());
        request.param("client_secret", this.serverConfig.getClientSecret());
        request.param("redirect_uri", this.serverConfig.getRedirectUri());
        request.header("Authorization", this.encodeAuthorization(this.serverConfig.getClientId().concat(":").concat(this.serverConfig.getClientSecret())));
    }

    protected void applyTokenParam(OAuth2Request request) {
        request.param("access_token", this.getAccessToken().getAccessToken());
        String tokenType = this.getAccessToken().getTokenType();
        request.header("Authorization", "Bearer " + this.getAccessToken().getAccessToken());
    }

    protected String getRealUrl(String url) {
        if (url.startsWith("http")) {
            return url;
        }
        if (!this.serverConfig.getApiBaseUrl().endsWith("/") && !url.startsWith("/")) {
            return this.serverConfig.getApiBaseUrl().concat("/").concat(url);
        }
        return this.serverConfig.getApiBaseUrl() + url;
    }

    @Override
    public OAuth2Session authorize() {
        this.setAccessTokenInfo(this.requestAccessToken());
        return this;
    }

    @Override
    public OAuth2Request request(String uriOrUrl) {
        if (this.accessTokenInfo == null) {
            this.authorize();
        }
        if (this.accessTokenInfo.isExpire()) {
            this.refreshToken();
        }
        OAuth2Request request = this.createRequest(this.getRealUrl(uriOrUrl));
        request.onTokenExpired(retry -> {
            this.refreshToken();
            this.applyTokenParam(request);
            retry.doReTry();
        });
        request.onRefreshTokenExpired(reTry -> {
            this.setAccessTokenInfo(this.requestAccessToken());
            this.applyTokenParam(request);
            reTry.doReTry();
        });
        this.applyTokenParam(request);
        return request;
    }

    @Override
    public OAuth2Session param(String name, Object value) {
        this.accessTokenRequest.param(name, String.valueOf(value));
        return this;
    }

    @Override
    public AccessTokenInfo requestAccessToken() {
        AccessTokenInfo accessTokenInfo = this.accessTokenRequest.param("scope", this.scope).post().onError(OAuth2Response.throwOnError).as(AccessTokenInfo.class);
        accessTokenInfo.setCreateTime(System.currentTimeMillis());
        accessTokenInfo.setUpdateTime(System.currentTimeMillis());
        return accessTokenInfo;
    }

    protected void refreshToken() {
        block4: {
            if (this.accessTokenInfo == null) {
                return;
            }
            OAuth2Request request = this.createRequest(this.getRealUrl(this.serverConfig.getAccessTokenUrl()));
            this.applyBasicAuthParam(request);
            boolean[] skip = new boolean[1];
            try {
                AccessTokenInfo tokenInfo = request.param("scope", this.scope).param("grant_type", "refresh_token").param("refresh_token", this.accessTokenInfo.getRefreshToken()).post().onError((oAuth2Response, type) -> {
                    if (type == ErrorType.EXPIRED_REFRESH_TOKEN) {
                        this.setAccessTokenInfo(this.requestAccessToken());
                        skip[0] = true;
                        return;
                    }
                    OAuth2Response.throwOnError.accept((OAuth2Response)oAuth2Response, (ErrorType)type);
                }).as(AccessTokenInfo.class);
                if (skip[0]) {
                    return;
                }
                tokenInfo.setCreateTime(this.accessTokenInfo.getCreateTime());
                tokenInfo.setUpdateTime(System.currentTimeMillis());
                this.setAccessTokenInfo(tokenInfo);
            }
            catch (BusinessException | OAuth2RequestException e) {
                if (skip[0]) break block4;
                throw e;
            }
        }
    }

    @Override
    public OAuth2Session scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public AccessTokenInfo getAccessToken() {
        if (this.accessTokenInfo == null) {
            return null;
        }
        if (this.accessTokenInfo.isExpire()) {
            this.refreshToken();
        }
        return this.accessTokenInfo;
    }

    private void setAccessTokenInfo(AccessTokenInfo accessTokenInfo) {
        this.accessTokenInfo = accessTokenInfo;
        if (this.onTokenChange != null) {
            this.onTokenChange.accept(accessTokenInfo);
        }
    }
}

