/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.client.simple.request;

import java.io.InputStream;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.hswebframework.expands.request.http.Response;
import org.hswebframework.web.authorization.oauth2.client.request.ResponseConvertHandler;
import org.hswebframework.web.authorization.oauth2.client.request.ResponseJudge;
import org.hswebframework.web.authorization.oauth2.client.response.OAuth2Response;
import org.hswebframework.web.authorization.oauth2.client.response.ResponseConvert;
import org.hswebframework.web.authorization.oauth2.client.simple.request.UnCheck;
import org.hswebframework.web.oauth2.core.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class SimpleOAuth2Response
implements OAuth2Response {
    private ResponseConvertHandler convertHandler;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ErrorType errorType;
    private byte[] data;
    private int status;
    private OAuth2Response proxy = this;
    private InputStream inputStream;

    public void judgeError(ErrorType ifError, Supplier<OAuth2Response> expiredCallBack) {
        if (this.errorType == ifError) {
            OAuth2Response retryRes = expiredCallBack.get();
            if (retryRes == null) {
                return;
            }
            this.proxy = retryRes;
            this.proxy.onError((retryResponse, type) -> {
                if (type == ifError) {
                    this.logger.error("still error [{}], maybe judge error or auth server error\uff01 {}", new Object[]{ifError, retryResponse, Thread.currentThread().getStackTrace()});
                } else {
                    this.errorType = type;
                }
            });
            this.data = UnCheck.unCheck(this.proxy::asBytes);
            this.status = this.proxy.status();
        }
    }

    public SimpleOAuth2Response(Response response, ResponseConvertHandler convertHandler, ResponseJudge responseJudge) {
        this.convertHandler = convertHandler;
        this.inputStream = UnCheck.unCheck(() -> ((Response)response).asStream());
        this.status = response.getCode();
        this.errorType = responseJudge.judge(this);
    }

    @Override
    public InputStream asStream() {
        return this.inputStream;
    }

    @Override
    public String asString() {
        if (this.asBytes() == null) {
            return null;
        }
        return new String(this.asBytes());
    }

    @Override
    public byte[] asBytes() {
        if (this.data == null) {
            this.data = UnCheck.unCheck(() -> StreamUtils.copyToByteArray((InputStream)this.inputStream));
        }
        return this.data;
    }

    @Override
    public <T> T as(ResponseConvert<T> convert) {
        return convert.convert(this);
    }

    @Override
    public <T> T as(Class<T> type) {
        return this.convertHandler.convert(this, type);
    }

    @Override
    public <T> List<T> asList(Class<T> type) {
        return this.convertHandler.convertList(this, type);
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public OAuth2Response onError(BiConsumer<OAuth2Response, ErrorType> onError) {
        if (null != this.errorType) {
            onError.accept(this.proxy, this.errorType);
        }
        return this.proxy;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }
}

