/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.client.simple.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.hswebframework.web.authorization.oauth2.client.request.definition.ResponseJudgeForProviderDefinition;
import org.hswebframework.web.authorization.oauth2.client.response.OAuth2Response;
import org.hswebframework.web.oauth2.core.ErrorType;

public class HswebResponseJudgeSupport
implements ResponseJudgeForProviderDefinition {
    @Override
    public String getProvider() {
        return "hsweb";
    }

    @Override
    public ErrorType judge(OAuth2Response response) {
        if (response.status() != 500) {
            return null;
        }
        String result = response.asString();
        if (result == null) {
            return ErrorType.OTHER;
        }
        if (!result.trim().startsWith("{")) {
            return null;
        }
        try {
            JSONObject jsonRes = JSON.parseObject((String)result);
            if (jsonRes.size() > 5) {
                return null;
            }
            Integer status = jsonRes.getInteger("status");
            if (status == null && response.status() == 200) {
                return null;
            }
            if (status != null) {
                if (status == 200) {
                    return null;
                }
                return ErrorType.fromCode((int)status).orElse(ErrorType.OTHER);
            }
            if (jsonRes.get((Object)"message") != null) {
                return ErrorType.valueOf((String)jsonRes.getString("message"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

