/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.client.simple.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.web.BusinessException;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.builder.AuthenticationBuilderFactory;
import org.hswebframework.web.authorization.oauth2.client.exception.OAuth2RequestException;
import org.hswebframework.web.authorization.oauth2.client.request.definition.ResponseConvertForProviderDefinition;
import org.hswebframework.web.authorization.oauth2.client.response.OAuth2Response;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.oauth2.core.ErrorType;

public class HswebResponseConvertSupport
implements ResponseConvertForProviderDefinition {
    private AuthenticationBuilderFactory authenticationBuilderFactory;
    private static int responseMessageFieldSize = 4;
    Function<Object, Authentication> autzParser = obj -> (Authentication)this.convertAuthentication(JSON.toJSONString((Object)obj));
    private static final Set<String> springMvcErrorResponseKeys = new HashSet<String>(Arrays.asList("exception", "path", "error", "message", "timestamp", "status"));

    public HswebResponseConvertSupport(AuthenticationBuilderFactory authenticationBuilderFactory) {
        this.authenticationBuilderFactory = authenticationBuilderFactory;
    }

    public Object tryConvertToObject(String json, Class type, OAuth2Response response) {
        if (json.startsWith("{")) {
            if (ResponseMessage.class.isAssignableFrom(type)) {
                return JSON.parseObject((String)json, (Class)type);
            }
            JSONObject message = JSON.parseObject((String)json, (Feature[])new Feature[]{Feature.DisableFieldSmartMatch});
            if (message.size() <= responseMessageFieldSize && message.get((Object)"status") != null && message.get((Object)"timestamp") != null) {
                Integer status = message.getInteger("status");
                if (status != 200) {
                    throw new BusinessException(message.getString("message"), status.intValue());
                }
                Object data = message.get((Object)"result");
                if (data == null) {
                    return null;
                }
                if (data instanceof JSONObject) {
                    if (type == Authentication.class) {
                        return this.autzParser.apply(data);
                    }
                    return ((JSONObject)data).toJavaObject(type);
                }
                if (data instanceof JSONArray) {
                    if (type == Authentication.class) {
                        return ((JSONArray)data).stream().map(this.autzParser).collect(Collectors.toList());
                    }
                    return ((JSONArray)data).toJavaList(type);
                }
                return message.getObject("result", type);
            }
            if (springMvcErrorResponseKeys.containsAll(message.keySet())) {
                throw new OAuth2RequestException(ErrorType.SERVICE_ERROR, response);
            }
            return message.toJavaObject(type);
        }
        if (json.startsWith("[")) {
            if (type == Authentication.class) {
                return JSON.parseArray((String)json).stream().map(this.autzParser).collect(Collectors.toList());
            }
            return JSON.parseArray((String)json, (Class)type);
        }
        return null;
    }

    protected <T> T convertAuthentication(String json) {
        if (this.authenticationBuilderFactory != null) {
            return (T)this.authenticationBuilderFactory.create().json(json).build();
        }
        throw new UnsupportedOperationException("authenticationBuilderFactory not ready");
    }

    @Override
    public <T> T convert(OAuth2Response response, Class<T> type) {
        String json = response.asString();
        Object data = this.tryConvertToObject(json, type, response);
        if (null == data) {
            return null;
        }
        if (type.isInstance(data)) {
            return (T)data;
        }
        if (data instanceof ResponseMessage) {
            throw new OAuth2RequestException(((ResponseMessage)data).getMessage(), ErrorType.SERVICE_ERROR, response);
        }
        throw new OAuth2RequestException(ErrorType.PARSE_RESPONSE_ERROR, response);
    }

    @Override
    public <T> List<T> convertList(OAuth2Response response, Class<T> type) {
        String json = response.asString();
        Object data = this.tryConvertToObject(json, type, response);
        if (null == data) {
            return null;
        }
        if (data instanceof List) {
            return (List)data;
        }
        if (data instanceof ResponseMessage) {
            throw new OAuth2RequestException(((ResponseMessage)data).getMessage(), ErrorType.SERVICE_ERROR, response);
        }
        throw new OAuth2RequestException(ErrorType.PARSE_RESPONSE_ERROR, response);
    }

    @Override
    public String getProvider() {
        return "hsweb";
    }
}

