/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.client.request;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.web.authorization.oauth2.client.request.ResponseJudge;
import org.hswebframework.web.authorization.oauth2.client.response.OAuth2Response;
import org.hswebframework.web.oauth2.core.ErrorType;

public class DefaultResponseJudge
implements ResponseJudge {
    private static List<ErrorType> errorTypes = Arrays.stream(ErrorType.values()).filter(errorType -> errorType != ErrorType.OTHER).collect(Collectors.toList());

    @Override
    public ErrorType judge(OAuth2Response response) {
        if (response.status() == 200) {
            return null;
        }
        String result = response.asString();
        if (result == null) {
            return ErrorType.OTHER;
        }
        return errorTypes.stream().filter(errorType -> result.contains(errorType.name().toLowerCase())).findAny().orElse(null);
    }
}

