/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.client;

import com.alibaba.fastjson.annotation.JSONField;
import java.beans.ConstructorProperties;
import java.io.Serializable;

public class AccessTokenInfo
implements Serializable {
    private static final long serialVersionUID = -6261971233479574076L;
    private String id;
    @JSONField(name="access_token")
    private String accessToken;
    @JSONField(name="refresh_token")
    private String refreshToken;
    @JSONField(name="expires_in")
    private Integer expiresIn;
    private String scope;
    private Long createTime;
    private Long updateTime;
    @JSONField(name="token_type")
    private String tokenType;
    private String grantType;
    private String serverId;

    public boolean isExpire() {
        if (this.expiresIn == null) {
            return true;
        }
        if (this.expiresIn <= 0) {
            return false;
        }
        long time = this.updateTime == null ? this.createTime : this.updateTime;
        return System.currentTimeMillis() - time > (long)(this.expiresIn * 1000);
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public static AccessTokenInfoBuilder builder() {
        return new AccessTokenInfoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public AccessTokenInfo() {
    }

    @ConstructorProperties(value={"id", "accessToken", "refreshToken", "expiresIn", "scope", "createTime", "updateTime", "tokenType", "grantType", "serverId"})
    public AccessTokenInfo(String id, String accessToken, String refreshToken, Integer expiresIn, String scope, Long createTime, Long updateTime, String tokenType, String grantType, String serverId) {
        this.id = id;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expiresIn = expiresIn;
        this.scope = scope;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.tokenType = tokenType;
        this.grantType = grantType;
        this.serverId = serverId;
    }

    public static class AccessTokenInfoBuilder {
        private String id;
        private String accessToken;
        private String refreshToken;
        private Integer expiresIn;
        private String scope;
        private Long createTime;
        private Long updateTime;
        private String tokenType;
        private String grantType;
        private String serverId;

        AccessTokenInfoBuilder() {
        }

        public AccessTokenInfoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AccessTokenInfoBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public AccessTokenInfoBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public AccessTokenInfoBuilder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public AccessTokenInfoBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public AccessTokenInfoBuilder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public AccessTokenInfoBuilder updateTime(Long updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public AccessTokenInfoBuilder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public AccessTokenInfoBuilder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public AccessTokenInfoBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public AccessTokenInfo build() {
            return new AccessTokenInfo(this.id, this.accessToken, this.refreshToken, this.expiresIn, this.scope, this.createTime, this.updateTime, this.tokenType, this.grantType, this.serverId);
        }

        public String toString() {
            return "AccessTokenInfo.AccessTokenInfoBuilder(id=" + this.id + ", accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", expiresIn=" + this.expiresIn + ", scope=" + this.scope + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", tokenType=" + this.tokenType + ", grantType=" + this.grantType + ", serverId=" + this.serverId + ")";
        }
    }
}

