/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.client.simple.request;

import java.io.InputStream;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hswebframework.expands.request.http.HttpRequest;
import org.hswebframework.expands.request.http.Response;
import org.hswebframework.web.authorization.oauth2.client.request.OAuth2Request;
import org.hswebframework.web.authorization.oauth2.client.request.ResponseConvertHandler;
import org.hswebframework.web.authorization.oauth2.client.request.ResponseJudge;
import org.hswebframework.web.authorization.oauth2.client.request.TokenExpiredCallBack;
import org.hswebframework.web.authorization.oauth2.client.response.OAuth2Response;
import org.hswebframework.web.authorization.oauth2.client.simple.request.SimpleOAuth2Response;
import org.hswebframework.web.authorization.oauth2.client.simple.request.UnCheck;
import org.hswebframework.web.oauth2.core.ErrorType;

public class SimpleOAuth2Request
implements OAuth2Request {
    private HttpRequest request;
    private ResponseConvertHandler convertHandler;
    private ResponseJudge responseJudge;
    private TokenExpiredCallBack expiredCallBack;
    private TokenExpiredCallBack refreshTokenExpiredCallBack;
    private volatile SimpleOAuth2Response auth2Response;

    public SimpleOAuth2Request(HttpRequest request) {
        this.request = request;
    }

    public void setConvertHandler(ResponseConvertHandler convertHandler) {
        this.convertHandler = convertHandler;
    }

    public void setResponseJudge(ResponseJudge responseJudge) {
        this.responseJudge = responseJudge;
    }

    @Override
    public OAuth2Request onRefreshTokenExpired(TokenExpiredCallBack refreshTokenExpiredCallBack) {
        this.refreshTokenExpiredCallBack = refreshTokenExpiredCallBack;
        return this;
    }

    @Override
    public OAuth2Request onTokenExpired(TokenExpiredCallBack callback) {
        this.expiredCallBack = callback;
        return this;
    }

    @Override
    public OAuth2Response upload(String name, InputStream inputStream) {
        return this.createUnCheckResponse(() -> this.request.upload(name, inputStream));
    }

    @Override
    public OAuth2Response upload(String name, InputStream inputStream, String fileName) {
        return this.createUnCheckResponse(() -> this.request.upload(name, inputStream, fileName));
    }

    @Override
    public OAuth2Request params(Map<String, String> params) {
        this.request.params(params);
        return this;
    }

    @Override
    public OAuth2Request param(String name, Object value) {
        if (value == null) {
            return this;
        }
        this.request.param(name, String.valueOf(value));
        return this;
    }

    @Override
    public OAuth2Request requestBody(String value) {
        this.request.requestBody(value);
        return this;
    }

    @Override
    public OAuth2Request header(String name, String value) {
        if (value == null) {
            return this;
        }
        this.request.header(name, value);
        return this;
    }

    @Override
    public OAuth2Request cookie(String cookie) {
        this.request.cookie(cookie);
        return this;
    }

    @Override
    public OAuth2Request contentType(String contentType) {
        this.request.contentType(contentType);
        return this;
    }

    @Override
    public OAuth2Request accept(String accept) {
        this.header("Accept", accept);
        return this;
    }

    @Override
    public OAuth2Request timeout(long millisecond, Consumer<OAuth2Request> timeoutCallBack) {
        return this;
    }

    protected SimpleOAuth2Response createNativeResponse(Supplier<Response> responseSupplier) {
        SimpleOAuth2Response response;
        this.auth2Response = response = new SimpleOAuth2Response(responseSupplier.get(), this.convertHandler, this.responseJudge);
        return this.auth2Response;
    }

    protected OAuth2Response createResponse(Supplier<Response> responseSupplier) {
        this.createNativeResponse(responseSupplier);
        if (null != this.expiredCallBack) {
            this.auth2Response.judgeError(ErrorType.EXPIRED_TOKEN, () -> {
                this.expiredCallBack.call(() -> this.lambda$null$2((Supplier)responseSupplier));
                return this.auth2Response;
            });
        }
        if (null != this.refreshTokenExpiredCallBack) {
            this.auth2Response.judgeError(ErrorType.INVALID_TOKEN, () -> {
                this.refreshTokenExpiredCallBack.call(() -> this.lambda$null$4((Supplier)responseSupplier));
                return this.auth2Response;
            });
            this.auth2Response.judgeError(ErrorType.EXPIRED_REFRESH_TOKEN, () -> {
                this.refreshTokenExpiredCallBack.call(() -> this.lambda$null$6((Supplier)responseSupplier));
                return this.auth2Response;
            });
            this.auth2Response.judgeError(ErrorType.INVALID_TOKEN, () -> {
                this.refreshTokenExpiredCallBack.call(() -> this.lambda$null$8((Supplier)responseSupplier));
                return this.auth2Response;
            });
        }
        return this.auth2Response;
    }

    protected OAuth2Response createUnCheckResponse(UnCheck<Response> unCheck) {
        return this.createResponse(() -> (Response)UnCheck.unCheck(unCheck));
    }

    @Override
    public OAuth2Response get() {
        return this.createUnCheckResponse(() -> ((HttpRequest)this.request).get());
    }

    @Override
    public OAuth2Response put() {
        return this.createUnCheckResponse(() -> ((HttpRequest)this.request).put());
    }

    @Override
    public OAuth2Response post() {
        return this.createUnCheckResponse(() -> ((HttpRequest)this.request).post());
    }

    @Override
    public OAuth2Response delete() {
        return this.createUnCheckResponse(() -> ((HttpRequest)this.request).delete());
    }

    @Override
    public OAuth2Response patch() {
        return this.createUnCheckResponse(() -> ((HttpRequest)this.request).patch());
    }

    private /* synthetic */ void lambda$null$8(Supplier responseSupplier) {
        this.createNativeResponse(responseSupplier);
    }

    private /* synthetic */ void lambda$null$6(Supplier responseSupplier) {
        this.createNativeResponse(responseSupplier);
    }

    private /* synthetic */ void lambda$null$4(Supplier responseSupplier) {
        this.createNativeResponse(responseSupplier);
    }

    private /* synthetic */ void lambda$null$2(Supplier responseSupplier) {
        this.createNativeResponse(responseSupplier);
    }
}

