/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.jwt;

import com.alibaba.fastjson.JSON;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;
import org.hswebframework.web.authorization.basic.web.ParsedToken;
import org.hswebframework.web.authorization.basic.web.UserTokenParser;
import org.hswebframework.web.authorization.jwt.JwtAuthorizedToken;
import org.hswebframework.web.authorization.jwt.JwtConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JwtTokenParser
implements UserTokenParser {
    private static final Logger logger = LoggerFactory.getLogger(JwtTokenParser.class);
    private JwtConfig jwtConfig;

    public JwtTokenParser(JwtConfig jwtConfig) {
        this.jwtConfig = jwtConfig;
    }

    public ParsedToken parseToken(HttpServletRequest request) {
        String headerToken = request.getHeader("jwt-token");
        if (StringUtils.isEmpty((Object)headerToken) && !StringUtils.isEmpty((Object)(headerToken = request.getHeader("Authorization"))) && headerToken.contains(" ")) {
            String[] auth = headerToken.split("[ ]");
            if (auth[0].equalsIgnoreCase("jwt") || auth[0].equalsIgnoreCase("Bearer")) {
                headerToken = auth[1];
            } else {
                return null;
            }
        }
        if (headerToken != null) {
            try {
                Claims claims = this.parseJWT(headerToken);
                if (claims.getExpiration().getTime() <= System.currentTimeMillis()) {
                    return null;
                }
                return (ParsedToken)JSON.parseObject((String)claims.getSubject(), JwtAuthorizedToken.class);
            }
            catch (ExpiredJwtException e) {
                return null;
            }
            catch (Exception e) {
                logger.debug("parse token [{}] error", (Object)headerToken, (Object)e);
                return null;
            }
        }
        return null;
    }

    public Claims parseJWT(String jwt) {
        SecretKey key = this.jwtConfig.generalKey();
        return (Claims)Jwts.parser().setSigningKey((Key)key).parseClaimsJws(jwt).getBody();
    }
}

