/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.jwt;

import com.alibaba.fastjson.JSON;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.basic.web.GeneratedToken;
import org.hswebframework.web.authorization.basic.web.UserTokenGenerator;
import org.hswebframework.web.authorization.jwt.JwtAuthorizedToken;
import org.hswebframework.web.authorization.jwt.JwtConfig;
import org.hswebframework.web.id.IDGenerator;

public class JwtTokenGenerator
implements UserTokenGenerator {
    private JwtConfig jwtConfig;

    public JwtTokenGenerator(JwtConfig jwtConfig) {
        this.jwtConfig = jwtConfig;
    }

    public String getSupportTokenType() {
        return "jwt";
    }

    private String createToken() {
        return (String)IDGenerator.MD5.generate();
    }

    public GeneratedToken generate(Authentication authentication) {
        final String token = this.createToken();
        String userId = authentication.getUser().getId();
        String subject = JSON.toJSONString((Object)new JwtAuthorizedToken(token, userId));
        final String jwtToken = this.createJWT(this.jwtConfig.getId(), subject, this.jwtConfig.getTtl());
        final int timeout = this.jwtConfig.getTtl();
        return new GeneratedToken(){
            private static final long serialVersionUID = -4362122360342275321L;

            public Map<String, Object> getResponse() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("token", jwtToken);
                return map;
            }

            public String getToken() {
                return token;
            }

            public String getType() {
                return "jwt";
            }

            public int getTimeout() {
                return timeout;
            }
        };
    }

    public String createJWT(String id, String subject, long ttlMillis) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        SecretKey key = this.jwtConfig.generalKey();
        JwtBuilder builder = Jwts.builder().setId(id).setIssuedAt(now).setSubject(subject).signWith(signatureAlgorithm, (Key)key);
        if (ttlMillis >= 0L) {
            long expMillis = nowMillis + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }
}

