/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hswebframework.web.authorization.basic.web.GeneratedToken;
import org.hswebframework.web.authorization.basic.web.ReactiveUserTokenGenerator;
import org.hswebframework.web.authorization.basic.web.ReactiveUserTokenParser;
import org.hswebframework.web.authorization.events.AuthorizationSuccessEvent;
import org.hswebframework.web.authorization.token.ParsedToken;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.context.ContextUtils;
import org.hswebframework.web.logger.ReactiveLogger;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.event.EventListener;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class UserTokenWebFilter
implements WebFilter,
BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(UserTokenWebFilter.class);
    private final List<ReactiveUserTokenParser> parsers = new ArrayList<ReactiveUserTokenParser>();
    private final Map<String, ReactiveUserTokenGenerator> tokenGeneratorMap = new HashMap<String, ReactiveUserTokenGenerator>();
    @Autowired
    private UserTokenManager userTokenManager;

    @NonNull
    public Mono<Void> filter(@NonNull ServerWebExchange exchange, WebFilterChain chain) {
        return chain.filter(exchange).subscriberContext(ContextUtils.acceptContext(ctx -> Flux.fromIterable(this.parsers).flatMap(parser -> parser.parseToken(exchange)).subscribe(token -> ctx.put(ParsedToken.class, token)))).subscriberContext(ReactiveLogger.start((String)"requestId", (String)exchange.getRequest().getId()));
    }

    @EventListener
    public void handleUserSign(AuthorizationSuccessEvent event) {
        ReactiveUserTokenGenerator generator = event.getParameter("tokenType").map(this.tokenGeneratorMap::get).orElseGet(() -> this.tokenGeneratorMap.get("default"));
        if (generator != null) {
            GeneratedToken token = generator.generate(event.getAuthentication());
            event.getResult().putAll(token.getResponse());
            if (StringUtils.hasText((String)token.getToken())) {
                event.getResult().put("token", token.getToken());
                long expires = event.getParameter("expires").map(String::valueOf).map(Long::parseLong).orElse(token.getTimeout());
                event.getResult().put("expires", expires);
                event.async((Publisher)this.userTokenManager.signIn(token.getToken(), token.getType(), event.getAuthentication().getUser().getId(), expires).doOnNext(t -> log.debug("user [{}] sign in", (Object)t.getUserId())).then());
            }
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ReactiveUserTokenGenerator) {
            ReactiveUserTokenGenerator generator = (ReactiveUserTokenGenerator)bean;
            this.tokenGeneratorMap.put(generator.getTokenType(), generator);
        }
        if (bean instanceof ReactiveUserTokenParser) {
            this.parsers.add((ReactiveUserTokenParser)bean);
        }
        return bean;
    }
}

