/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.web;

import io.swagger.annotations.ApiOperation;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.ReactiveAuthenticationManager;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.authorization.token.ParsedToken;
import org.hswebframework.web.authorization.token.TokenState;
import org.hswebframework.web.authorization.token.UserToken;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.context.ContextKey;
import org.hswebframework.web.context.ContextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping
@Authorize
@Resource(id="user-token", name="\u7528\u6237\u4ee4\u724c\u4fe1\u606f\u7ba1\u7406")
public class ReactiveUserTokenController {
    private UserTokenManager userTokenManager;
    private ReactiveAuthenticationManager authenticationManager;

    @Autowired
    @Lazy
    public void setUserTokenManager(UserTokenManager userTokenManager) {
        this.userTokenManager = userTokenManager;
    }

    @Autowired
    @Lazy
    public void setAuthenticationManager(ReactiveAuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    @GetMapping(value={"/user-token/reset"})
    @Authorize(merge=false)
    @ApiOperation(value="\u91cd\u7f6e\u5f53\u524d\u7528\u6237\u7684\u4ee4\u724c")
    public Mono<Boolean> resetToken() {
        return ContextUtils.reactiveContext().map(context -> (ParsedToken)context.get(ContextKey.of(ParsedToken.class)).orElseThrow(UnAuthorizedException::new)).flatMap(token -> this.userTokenManager.signOutByToken(token.getToken())).thenReturn((Object)true);
    }

    @PutMapping(value={"/user-token/check"})
    @ApiOperation(value="\u68c0\u67e5\u6240\u6709\u5df2\u8fc7\u671f\u7684token\u5e76\u79fb\u9664")
    @SaveAction
    public Mono<Boolean> checkExpiredToken() {
        return this.userTokenManager.checkExpiredToken().thenReturn((Object)true);
    }

    @GetMapping(value={"/user-token/token/{token}"})
    @ApiOperation(value="\u6839\u636etoken\u83b7\u53d6\u4ee4\u724c\u4fe1\u606f")
    @QueryAction
    public Mono<UserToken> getByToken(@PathVariable String token) {
        return this.userTokenManager.getByToken(token);
    }

    @GetMapping(value={"/user-token/user/{userId}"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u5168\u90e8\u4ee4\u724c\u4fe1\u606f")
    @QueryAction
    public Flux<UserToken> getByUserId(@PathVariable String userId) {
        return this.userTokenManager.getByUserId(userId);
    }

    @GetMapping(value={"/user-token/user/{userId}/logged"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u5224\u65ad\u7528\u6237\u662f\u5426\u5df2\u7ecf\u767b\u5f55")
    @QueryAction
    public Mono<Boolean> userIsLoggedIn(@PathVariable String userId) {
        return this.userTokenManager.userIsLoggedIn(userId);
    }

    @GetMapping(value={"/user-token/token/{token}/logged"})
    @ApiOperation(value="\u6839\u636e\u4ee4\u724c\u5224\u65ad\u7528\u6237\u662f\u5426\u5df2\u7ecf\u767b\u5f55")
    @QueryAction
    public Mono<Boolean> tokenIsLoggedIn(@PathVariable String token) {
        return this.userTokenManager.tokenIsLoggedIn(token);
    }

    @GetMapping(value={"/user-token/user/total"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u5df2\u7ecf\u767b\u5f55\u7684\u7528\u6237\u6570\u91cf")
    @Authorize(merge=false)
    public Mono<Integer> totalUser() {
        return this.userTokenManager.totalUser();
    }

    @GetMapping(value={"/user-token/token/total"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u5df2\u7ecf\u767b\u5f55\u7684\u4ee4\u724c\u6570\u91cf")
    @Authorize(merge=false)
    public Mono<Integer> totalToken() {
        return this.userTokenManager.totalToken();
    }

    @GetMapping(value={"/user-token"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u7528\u6237\u4ee4\u724c\u4fe1\u606f")
    @QueryAction
    public Flux<UserToken> allLoggedUser() {
        return this.userTokenManager.allLoggedUser();
    }

    @DeleteMapping(value={"/user-token/user/{userId}"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u5c06\u7528\u6237\u8e22\u4e0b\u7ebf")
    @SaveAction
    public Mono<Void> signOutByUserId(@PathVariable String userId) {
        return this.userTokenManager.signOutByUserId(userId);
    }

    @DeleteMapping(value={"/user-token/token/{token}"})
    @ApiOperation(value="\u6839\u636e\u4ee4\u724c\u5c06\u7528\u6237\u8e22\u4e0b\u7ebf")
    @SaveAction
    public Mono<Void> signOutByToken(@PathVariable String token) {
        return this.userTokenManager.signOutByToken(token);
    }

    @SaveAction
    @PutMapping(value={"/user-token/user/{userId}/{state}"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u66f4\u65b0\u7528\u6237\u4ee4\u724c\u72b6\u6001")
    public Mono<Void> changeUserState(@PathVariable String userId, @PathVariable TokenState state) {
        return this.userTokenManager.changeUserState(userId, state);
    }

    @PutMapping(value={"/user-token/token/{token}/{state}"})
    @ApiOperation(value="\u6839\u636e\u4ee4\u724c\u66f4\u65b0\u7528\u6237\u4ee4\u724c\u72b6\u6001")
    @SaveAction
    public Mono<Void> changeTokenState(@PathVariable String token, @PathVariable TokenState state) {
        return this.userTokenManager.changeTokenState(token, state);
    }

    @PostMapping(value={"/user-token/{token}/{type}/{userId}/{maxInactiveInterval}"})
    @ApiOperation(value="\u5c06\u7528\u6237\u8bbe\u7f6e\u4e3a\u767b\u5f55")
    @SaveAction
    public Mono<UserToken> signIn(@PathVariable String token, @PathVariable String type, @PathVariable String userId, @PathVariable long maxInactiveInterval) {
        return this.userTokenManager.signIn(token, type, userId, maxInactiveInterval);
    }

    @GetMapping(value={"/user-token/{token}/touch"})
    @ApiOperation(value="\u66f4\u65b0token\u6709\u6548\u671f")
    @SaveAction
    public Mono<Void> touch(@PathVariable String token) {
        return this.userTokenManager.touch(token);
    }

    @GetMapping(value={"/user-auth/{userId}"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7528\u6237\u7684\u6743\u9650\u4fe1\u606f")
    @SaveAction
    public Mono<Authentication> userAuthInfo(@PathVariable String userId) {
        return this.authenticationManager.getByUserId(userId);
    }
}

