/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.web;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import java.util.function.Function;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.ReactiveAuthenticationManager;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.events.AuthorizationBeforeEvent;
import org.hswebframework.web.authorization.events.AuthorizationDecodeEvent;
import org.hswebframework.web.authorization.events.AuthorizationFailedEvent;
import org.hswebframework.web.authorization.events.AuthorizationSuccessEvent;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.authorization.simple.PlainTextUsernamePasswordAuthenticationRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"${hsweb.web.mappings.authorize:authorize}"})
public class AuthorizationController {
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private ReactiveAuthenticationManager authenticationManager;

    @GetMapping(value={"/me"})
    @Authorize
    @ApiOperation(value="\u5f53\u524d\u767b\u5f55\u7528\u6237\u6743\u9650\u4fe1\u606f")
    public Mono<Authentication> me() {
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new));
    }

    @PostMapping(value={"/login"}, consumes={"application/json"})
    @ApiOperation(value="\u7528\u6237\u540d\u5bc6\u7801\u767b\u5f55,json\u65b9\u5f0f")
    @Authorize(ignore=true)
    public Mono<Map<String, Object>> authorizeByJson(@ApiParam(example="{\"username\":\"admin\",\"password\":\"admin\"}") @RequestBody Mono<Map<String, Object>> parameter) {
        return this.doLogin(parameter);
    }

    @PostMapping(value={"/login"}, consumes={"application/x-www-form-urlencoded"})
    @ApiOperation(value="\u7528\u6237\u540d\u5bc6\u7801\u767b\u5f55,\u53c2\u6570\u65b9\u5f0f")
    @Authorize(ignore=true)
    public Mono<Map<String, Object>> authorizeByUrlEncoded(@ApiParam(hidden=true) @RequestParam Map<String, Object> parameter) {
        return this.doLogin((Mono<Map<String, Object>>)Mono.just(parameter));
    }

    private Mono<Map<String, Object>> doLogin(Mono<Map<String, Object>> parameter) {
        return parameter.flatMap(parameters -> {
            String username = (String)parameters.get("username");
            String password = (String)parameters.get("password");
            Assert.hasLength((String)username, (String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasLength((String)password, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AuthorizationFailedEvent.Reason reason = AuthorizationFailedEvent.Reason.OTHER;
            Function<String, Object> parameterGetter = parameters::get;
            try {
                AuthorizationDecodeEvent decodeEvent = new AuthorizationDecodeEvent(username, password, parameterGetter);
                this.eventPublisher.publishEvent((ApplicationEvent)decodeEvent);
                username = decodeEvent.getUsername();
                password = decodeEvent.getPassword();
                AuthorizationBeforeEvent beforeEvent = new AuthorizationBeforeEvent(username, password, parameterGetter);
                this.eventPublisher.publishEvent((ApplicationEvent)beforeEvent);
                return this.authenticationManager.authenticate(Mono.just((Object)new PlainTextUsernamePasswordAuthenticationRequest(username, password))).switchIfEmpty(Mono.error(() -> new IllegalArgumentException("\u5bc6\u7801\u9519\u8bef"))).map(auth -> {
                    AuthorizationSuccessEvent event = new AuthorizationSuccessEvent(auth, parameterGetter);
                    event.getResult().put("userId", auth.getUser().getId());
                    this.eventPublisher.publishEvent((ApplicationEvent)event);
                    return event.getResult();
                });
            }
            catch (Exception e) {
                AuthorizationFailedEvent failedEvent = new AuthorizationFailedEvent(username, password, parameterGetter, reason);
                failedEvent.setException(e);
                this.eventPublisher.publishEvent((ApplicationEvent)failedEvent);
                return Mono.error((Throwable)failedEvent.getException());
            }
        });
    }
}

