/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.twofactor;

import java.beans.ConstructorProperties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.User;
import org.hswebframework.web.authorization.annotation.TwoFactor;
import org.hswebframework.web.authorization.exception.NeedTwoFactorException;
import org.hswebframework.web.authorization.twofactor.TwoFactorValidator;
import org.hswebframework.web.authorization.twofactor.TwoFactorValidatorManager;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class TwoFactorHandlerInterceptorAdapter
extends HandlerInterceptorAdapter {
    private TwoFactorValidatorManager validatorManager;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            TwoFactor factor = (TwoFactor)method.getMethodAnnotation(TwoFactor.class);
            if (factor == null || factor.ignore()) {
                return true;
            }
            String userId = Authentication.current().map(Authentication::getUser).map(User::getId).orElse(null);
            TwoFactorValidator validator = this.validatorManager.getValidator(userId, factor.value(), factor.provider());
            if (!validator.expired()) {
                return true;
            }
            String code = request.getParameter(factor.parameter());
            if (code == null) {
                code = request.getHeader(factor.parameter());
            }
            if (StringUtils.isEmpty((Object)code)) {
                throw new NeedTwoFactorException(factor.message(), factor.provider());
            }
            if (!validator.verify(code, factor.timeout())) {
                throw new NeedTwoFactorException("\u9a8c\u8bc1\u7801\u9519\u8bef", factor.provider());
            }
        }
        return super.preHandle(request, response, handler);
    }

    @ConstructorProperties(value={"validatorManager"})
    public TwoFactorHandlerInterceptorAdapter(TwoFactorValidatorManager validatorManager) {
        this.validatorManager = validatorManager;
    }
}

