/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.define;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.DataAccess;
import org.hswebframework.web.authorization.annotation.DataAccessType;
import org.hswebframework.web.authorization.annotation.Dimension;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.ResourceAction;
import org.hswebframework.web.authorization.basic.define.DefaultBasicAuthorizeDefinition;
import org.hswebframework.web.authorization.define.AopAuthorizeDefinition;
import org.hswebframework.web.authorization.define.ResourceActionDefinition;
import org.hswebframework.web.authorization.define.ResourceDefinition;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class AopAuthorizeDefinitionParser {
    private static final Set<Class<? extends Annotation>> types = new HashSet<Class>(Arrays.asList(Authorize.class, DataAccess.class, Dimension.class, Resource.class, ResourceAction.class, DataAccessType.class));
    private Set<Annotation> methodAnnotation;
    private Set<Annotation> classAnnotation;
    private Map<Class<? extends Annotation>, List<Annotation>> classAnnotationGroup;
    private Map<Class<? extends Annotation>, List<Annotation>> methodAnnotationGroup;
    private DefaultBasicAuthorizeDefinition definition = new DefaultBasicAuthorizeDefinition();

    AopAuthorizeDefinitionParser(Class<?> targetClass, Method method) {
        this.definition.setTargetClass(targetClass);
        this.definition.setTargetMethod(method);
        this.methodAnnotation = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, types);
        this.classAnnotation = AnnotatedElementUtils.findAllMergedAnnotations(targetClass, types);
        this.classAnnotationGroup = this.classAnnotation.stream().collect(Collectors.groupingBy(Annotation::annotationType));
        this.methodAnnotationGroup = this.methodAnnotation.stream().collect(Collectors.groupingBy(Annotation::annotationType));
    }

    private void initClassAnnotation() {
        for (Annotation annotation : this.classAnnotation) {
            if (annotation instanceof Authorize) {
                this.definition.putAnnotation((Authorize)annotation);
            }
            if (!(annotation instanceof Resource)) continue;
            this.definition.putAnnotation((Resource)annotation);
        }
    }

    private void initMethodAnnotation() {
        for (Annotation annotation : this.methodAnnotation) {
            if (annotation instanceof Authorize) {
                this.definition.putAnnotation((Authorize)annotation);
            }
            if (annotation instanceof Resource) {
                this.definition.putAnnotation((Resource)annotation);
            }
            if (!(annotation instanceof Dimension)) continue;
            this.definition.putAnnotation((Dimension)annotation);
        }
    }

    private void initClassDataAccessAnnotation() {
        for (Annotation annotation : this.classAnnotation) {
            if (!(annotation instanceof DataAccessType) && !(annotation instanceof DataAccess)) continue;
            for (ResourceDefinition resource : this.definition.getResources().getResources()) {
                for (ResourceActionDefinition action : resource.getActions()) {
                    if (annotation instanceof DataAccessType) {
                        this.definition.putAnnotation(action, (DataAccessType)annotation);
                        continue;
                    }
                    this.definition.putAnnotation(action, (DataAccess)annotation);
                }
            }
        }
    }

    private void initMethodDataAccessAnnotation() {
        for (Annotation annotation : this.methodAnnotation) {
            if (annotation instanceof ResourceAction) {
                this.getAnnotationByType(Resource.class).map(res -> this.definition.getResources().getResource(res.id()).orElse(null)).filter(Objects::nonNull).forEach(res -> {
                    ResourceAction ra = (ResourceAction)annotation;
                    ResourceActionDefinition action = this.definition.putAnnotation((ResourceDefinition)res, ra);
                    this.getAnnotationByType(DataAccessType.class).findFirst().ifPresent(dat -> this.definition.putAnnotation(action, (DataAccessType)dat));
                });
            }
            Optional<ResourceActionDefinition> actionDefinition = this.getAnnotationByType(Resource.class).map(res -> this.definition.getResources().getResource(res.id()).orElse(null)).filter(Objects::nonNull).flatMap(res -> this.getAnnotationByType(ResourceAction.class).map(ra -> res.getAction(ra.id()).orElse(null))).filter(Objects::nonNull).findFirst();
            if (annotation instanceof DataAccessType) {
                actionDefinition.ifPresent(ra -> this.definition.putAnnotation((ResourceActionDefinition)ra, (DataAccessType)annotation));
            }
            if (!(annotation instanceof DataAccess)) continue;
            actionDefinition.ifPresent(ra -> {
                this.definition.putAnnotation((ResourceActionDefinition)ra, (DataAccess)annotation);
                this.getAnnotationByType(DataAccessType.class).findFirst().ifPresent(dat -> this.definition.putAnnotation((ResourceActionDefinition)ra, (DataAccessType)dat));
            });
        }
    }

    AopAuthorizeDefinition parse() {
        this.initClassAnnotation();
        this.initClassDataAccessAnnotation();
        this.initMethodAnnotation();
        this.initMethodDataAccessAnnotation();
        return this.definition;
    }

    private <T extends Annotation> Stream<T> getAnnotationByType(Class<T> type) {
        return Optional.ofNullable(this.methodAnnotationGroup.getOrDefault(type, this.classAnnotationGroup.get(type))).map(Collection::stream).orElseGet(Stream::empty).map(type::cast);
    }
}

