/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import java.util.function.Function;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.ReactiveAuthenticationManager;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.events.AuthorizationBeforeEvent;
import org.hswebframework.web.authorization.events.AuthorizationDecodeEvent;
import org.hswebframework.web.authorization.events.AuthorizationFailedEvent;
import org.hswebframework.web.authorization.events.AuthorizationSuccessEvent;
import org.hswebframework.web.authorization.exception.AuthenticationException;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.authorization.simple.PlainTextUsernamePasswordAuthenticationRequest;
import org.hswebframework.web.logging.AccessLogger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"${hsweb.web.mappings.authorize:authorize}"})
@Tag(name="\u6388\u6743\u63a5\u53e3")
public class AuthorizationController {
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private ReactiveAuthenticationManager authenticationManager;

    @GetMapping(value={"/me"})
    @Authorize
    @Operation(summary="\u5f53\u524d\u767b\u5f55\u7528\u6237\u6743\u9650\u4fe1\u606f")
    public Mono<Authentication> me() {
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new));
    }

    @PostMapping(value={"/login"}, consumes={"application/json"})
    @Authorize(ignore=true)
    @AccessLogger(ignore=true)
    @Operation(summary="\u767b\u5f55", description="\u5fc5\u8981\u53c2\u6570:username,password.\u6839\u636e\u914d\u7f6e\u4e0d\u540c,\u5176\u4ed6\u53c2\u6570\u4e5f\u4e0d\u540c,\u5982:\u9a8c\u8bc1\u7801\u7b49.")
    public Mono<Map<String, Object>> authorizeByJson(@Parameter(example="{\"username\":\"admin\",\"password\":\"admin\"}") @RequestBody Mono<Map<String, Object>> parameter) {
        return this.doLogin(parameter);
    }

    private Mono<Map<String, Object>> doLogin(Mono<Map<String, Object>> parameter) {
        return parameter.flatMap(parameters -> {
            String username_ = (String)parameters.get("username");
            String password_ = (String)parameters.get("password");
            Assert.hasLength((String)username_, (String)"validation.username_must_not_be_empty");
            Assert.hasLength((String)password_, (String)"validation.password_must_not_be_empty");
            Function<String, Object> parameterGetter = parameters::get;
            return Mono.defer(() -> {
                AuthorizationDecodeEvent decodeEvent = new AuthorizationDecodeEvent(username_, password_, parameterGetter);
                return decodeEvent.publish(this.eventPublisher).then(Mono.defer(() -> {
                    String username = decodeEvent.getUsername();
                    String password = decodeEvent.getPassword();
                    AuthorizationBeforeEvent beforeEvent = new AuthorizationBeforeEvent(username, password, parameterGetter);
                    return beforeEvent.publish(this.eventPublisher).then(this.authenticationManager.authenticate(Mono.just((Object)new PlainTextUsernamePasswordAuthenticationRequest(username, password))).switchIfEmpty(Mono.error(() -> new AuthenticationException(AuthenticationException.ILLEGAL_PASSWORD))).flatMap(auth -> {
                        AuthorizationSuccessEvent event = new AuthorizationSuccessEvent(auth, parameterGetter);
                        event.getResult().put("userId", auth.getUser().getId());
                        return event.publish(this.eventPublisher).then(Mono.fromCallable(() -> ((AuthorizationSuccessEvent)event).getResult()));
                    }));
                }));
            }).onErrorResume(err -> {
                AuthorizationFailedEvent failedEvent = new AuthorizationFailedEvent(username_, password_, parameterGetter);
                failedEvent.setException(err);
                return failedEvent.publish(this.eventPublisher).then(Mono.error((Throwable)failedEvent.getException()));
            });
        });
    }
}

