/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.handler.access;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.core.param.Param;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.api.crud.entity.Entity;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.Dimension;
import org.hswebframework.web.authorization.access.DataAccessConfig;
import org.hswebframework.web.authorization.access.DataAccessHandler;
import org.hswebframework.web.authorization.annotation.DimensionDataAccess;
import org.hswebframework.web.authorization.basic.handler.access.DataAccessHandlerContext;
import org.hswebframework.web.authorization.define.AuthorizingContext;
import org.hswebframework.web.authorization.define.Phased;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.authorization.simple.DimensionDataAccessConfig;
import org.hswebframework.web.bean.FastBeanCopier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DimensionDataAccessHandler
implements DataAccessHandler {
    private static final Logger log = LoggerFactory.getLogger(DimensionDataAccessHandler.class);
    private Map<Method, Map<String, MappingInfo>> cache = new ConcurrentHashMap<Method, Map<String, MappingInfo>>();
    private Set<Class<? extends Annotation>> ann = new HashSet<Class>(Arrays.asList(DimensionDataAccess.class, DimensionDataAccess.Mapping.class));

    public boolean isSupport(DataAccessConfig access) {
        return access instanceof DimensionDataAccessConfig;
    }

    public boolean handle(DataAccessConfig access, AuthorizingContext context) {
        DimensionDataAccessConfig config = (DimensionDataAccessConfig)access;
        DataAccessHandlerContext requestContext = DataAccessHandlerContext.of(context, config.getScopeType());
        if (!this.checkSupported(config, requestContext)) {
            return false;
        }
        switch (access.getAction()) {
            case "query": 
            case "get": {
                return this.doHandleQuery(config, requestContext);
            }
            case "add": 
            case "save": 
            case "update": {
                return this.doHandleUpdate(config, requestContext);
            }
            case "delete": {
                return this.doHandleDelete(config, requestContext);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("data access [{}] not support for {}", (Object)config.getType().getId(), (Object)access.getAction());
        }
        return true;
    }

    protected String getProperty(DimensionDataAccessConfig cfg, DataAccessHandlerContext ct) {
        return Optional.ofNullable(this.getMappingInfo(ct).get(cfg.getScopeType())).map(MappingInfo::getProperty).orElseGet(() -> {
            log.warn("{} not supported dimension data access", (Object)ct.getParamContext().getMethod());
            return null;
        });
    }

    protected boolean checkSupported(DimensionDataAccessConfig cfg, DataAccessHandlerContext ctx) {
        Authentication authentication = ctx.getAuthentication();
        if (CollectionUtils.isEmpty(ctx.getDimensions())) {
            log.warn("user:[{}] dimension not setup", (Object)authentication.getUser().getId());
            return false;
        }
        if (!this.getMappingInfo(ctx).containsKey(cfg.getScopeType())) {
            log.warn("{} not supported dimension data access.see annotation: @DimensionDataAccess", (Object)ctx.getParamContext().getMethod());
            return false;
        }
        return true;
    }

    protected boolean doHandleDelete(DimensionDataAccessConfig cfg, DataAccessHandlerContext context) {
        return this.doHandleUpdate(cfg, context);
    }

    protected Object handleById(DimensionDataAccessConfig config, DataAccessHandlerContext context, MappingInfo mappingInfo, Object id) {
        if (id instanceof Param || id instanceof Entity) {
            this.applyQueryParam(config, context, id);
            return id;
        }
        List<Dimension> dimensions = context.getDimensions();
        Set scope = CollectionUtils.isNotEmpty((Collection)config.getScope()) ? config.getScope() : dimensions.stream().map(Dimension::getId).collect(Collectors.toSet());
        Function<Collection, Mono> reactiveCheck = obj -> context.getRepository().findById(obj).doOnNext(r -> {
            Object val = ((HashMap)FastBeanCopier.copy((Object)r, new HashMap(), (Set)FastBeanCopier.include((String[])new String[]{mappingInfo.getProperty()}))).get(mappingInfo.getProperty());
            if (!StringUtils.isEmpty(val) && !scope.contains(val)) {
                throw new AccessDenyException();
            }
        }).then();
        if (id instanceof Publisher) {
            if (id instanceof Mono) {
                return ((Mono)id).flatMap(r -> {
                    if (r instanceof Param) {
                        this.applyQueryParam(config, context, r);
                        return Mono.just((Object)r);
                    }
                    return reactiveCheck.apply(r instanceof Collection ? (Set<Object>)r : Collections.singleton(r));
                }).then((Mono)id);
            }
            if (id instanceof Flux) {
                return ((Flux)id).filter(v -> {
                    if (v instanceof Param) {
                        this.applyQueryParam(config, context, v);
                        return false;
                    }
                    return true;
                }).collectList().flatMap(reactiveCheck).thenMany((Publisher)((Flux)id));
            }
        }
        Set<Object> idVal = id instanceof Collection ? (Set<Object>)id : Collections.singleton(id);
        Object result = context.getParamContext().getInvokeResult();
        if (result instanceof Mono) {
            context.getParamContext().setInvokeResult((Object)reactiveCheck.apply(idVal).then((Mono)result));
        } else if (result instanceof Flux) {
            context.getParamContext().setInvokeResult((Object)reactiveCheck.apply(idVal).thenMany((Publisher)((Flux)result)));
        } else {
            log.warn("unsupported handle data access by id :{}", (Object)context.getParamContext().getMethod());
        }
        return id;
    }

    protected boolean doHandleUpdate(DimensionDataAccessConfig cfg, DataAccessHandlerContext context) {
        MappingInfo info = this.getMappingInfo(context).get(cfg.getScopeType());
        if (info != null) {
            if (info.idParamIndex != -1) {
                Object param = context.getParamContext().getArguments()[info.idParamIndex];
                context.getParamContext().getArguments()[info.idParamIndex] = this.handleById(cfg, context, info, param);
                return true;
            }
        } else {
            return true;
        }
        boolean reactive = context.getParamContext().handleReactiveArguments(publisher -> {
            if (publisher instanceof Mono) {
                return Mono.from((Publisher)publisher).flatMap(payload -> this.applyReactiveUpdatePayload(cfg, info, Collections.singleton(payload), context).thenReturn(payload));
            }
            if (publisher instanceof Flux) {
                return Flux.from((Publisher)publisher).collectList().flatMapMany(list -> this.applyReactiveUpdatePayload(cfg, info, (Collection<?>)list, context).flatMapIterable(v -> list));
            }
            return publisher;
        });
        if (!reactive) {
            this.applyUpdatePayload(cfg, info, Arrays.stream(context.getParamContext().getArguments()).flatMap(obj -> {
                if (obj instanceof Collection) {
                    return ((Collection)obj).stream();
                }
                return Stream.of(obj);
            }).filter(Entity.class::isInstance).collect(Collectors.toSet()), context);
            return true;
        }
        return true;
    }

    protected void applyUpdatePayload(DimensionDataAccessConfig config, MappingInfo mappingInfo, Collection<?> payloads, DataAccessHandlerContext context) {
        List<Dimension> dimensions = context.getDimensions();
        Set scope = CollectionUtils.isNotEmpty((Collection)config.getScope()) ? config.getScope() : dimensions.stream().map(Dimension::getId).collect(Collectors.toSet());
        for (Object payload : payloads) {
            if (!(payload instanceof Entity)) continue;
            if (payload instanceof Param) {
                this.applyQueryParam(config, context, (Param)payload);
                continue;
            }
            String property = mappingInfo.getProperty();
            Map map = (Map)FastBeanCopier.copy(payload, new HashMap(), (Set)FastBeanCopier.include((String[])new String[]{property}));
            Object value = map.get(property);
            if (StringUtils.isEmpty(value)) {
                if (dimensions.size() != 1) continue;
                map.put(property, dimensions.get(0).getId());
                FastBeanCopier.copy((Object)map, payload, (String[])new String[]{property});
                continue;
            }
            if (!CollectionUtils.isNotEmpty(scope) || scope.contains(value)) continue;
            throw new AccessDenyException();
        }
    }

    protected Mono<Void> applyReactiveUpdatePayload(DimensionDataAccessConfig config, MappingInfo info, Collection<?> payloads, DataAccessHandlerContext context) {
        return Mono.fromRunnable(() -> this.applyUpdatePayload(config, info, payloads, context));
    }

    protected boolean hasAccessByProperty(Set<Object> scope, String property, Object payload) {
        Map values = (Map)FastBeanCopier.copy((Object)payload, new HashMap(), (Set)FastBeanCopier.include((String[])new String[]{property}));
        Object val = values.get(property);
        return val == null || scope.contains(val);
    }

    protected boolean doHandleQuery(DimensionDataAccessConfig cfg, DataAccessHandlerContext context) {
        MappingInfo mappingInfo = this.getMappingInfo(context).get(cfg.getScopeType());
        if (context.getDefinition().getResources().getPhased() == Phased.after) {
            Object result = context.getParamContext().getInvokeResult();
            Set<Object> scope = CollectionUtils.isNotEmpty((Collection)cfg.getScope()) ? cfg.getScope() : context.getDimensions().stream().map(Dimension::getId).collect(Collectors.toSet());
            String property = mappingInfo.getProperty();
            if (result instanceof Mono) {
                context.getParamContext().setInvokeResult((Object)((Mono)result).filter(data -> this.hasAccessByProperty(scope, property, data)));
                return true;
            }
            if (result instanceof Flux) {
                context.getParamContext().setInvokeResult((Object)((Flux)result).filter(data -> this.hasAccessByProperty(scope, property, data)));
                return true;
            }
            return this.hasAccessByProperty(scope, property, result);
        }
        if (mappingInfo.getIdParamIndex() >= 0) {
            Object param = context.getParamContext().getArguments()[mappingInfo.idParamIndex];
            context.getParamContext().getArguments()[mappingInfo.idParamIndex] = this.handleById(cfg, context, mappingInfo, param);
            return true;
        }
        boolean reactive = context.getParamContext().handleReactiveArguments(publisher -> {
            if (publisher instanceof Mono) {
                return Mono.from((Publisher)publisher).flatMap(param -> this.applyReactiveQueryParam(cfg, context, param).thenReturn(param));
            }
            return publisher;
        });
        if (!reactive) {
            Object[] args = context.getParamContext().getArguments();
            this.applyQueryParam(cfg, context, args);
        }
        return true;
    }

    protected String getTermType(DimensionDataAccessConfig cfg) {
        return "in";
    }

    protected void applyQueryParam(DimensionDataAccessConfig cfg, DataAccessHandlerContext requestContext, Param param) {
        Set scope = CollectionUtils.isNotEmpty((Collection)cfg.getScope()) ? cfg.getScope() : requestContext.getDimensions().stream().map(Dimension::getId).collect(Collectors.toSet());
        QueryParamEntity entity = new QueryParamEntity();
        entity.setTerms(new ArrayList(param.getTerms()));
        entity.toNestQuery(query -> query.where(this.getProperty(cfg, requestContext), this.getTermType(cfg), (Object)scope));
        param.setTerms(entity.getTerms());
    }

    protected void applyQueryParam(DimensionDataAccessConfig cfg, DataAccessHandlerContext requestContext, Object ... params) {
        for (Object param : params) {
            if (!(param instanceof QueryParam)) continue;
            this.applyQueryParam(cfg, requestContext, (Param)((QueryParam)param));
        }
    }

    protected Mono<Void> applyReactiveQueryParam(DimensionDataAccessConfig cfg, DataAccessHandlerContext requestContext, Object ... param) {
        return Mono.fromRunnable(() -> this.applyQueryParam(cfg, requestContext, param));
    }

    public Map<String, MappingInfo> getMappingInfo(DataAccessHandlerContext context) {
        return this.getMappingInfo(ClassUtils.getUserClass((Object)context.getParamContext().getTarget()), context.getParamContext().getMethod());
    }

    private Map<String, MappingInfo> getMappingInfo(Class target, Method method) {
        return this.cache.computeIfAbsent(method, m -> {
            Set methodAnnotation = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, this.ann);
            Set classAnnotation = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)target, this.ann);
            ArrayList all = new ArrayList(classAnnotation);
            all.addAll(methodAnnotation);
            if (CollectionUtils.isEmpty(all)) {
                return Collections.emptyMap();
            }
            HashMap<String, MappingInfo> mappingInfoMap = new HashMap<String, MappingInfo>();
            for (Annotation annotation : all) {
                if (annotation instanceof DimensionDataAccess) {
                    for (DimensionDataAccess.Mapping mapping : ((DimensionDataAccess)annotation).mapping()) {
                        mappingInfoMap.put(mapping.dimensionType(), MappingInfo.of(mapping));
                    }
                }
                if (!(annotation instanceof DimensionDataAccess.Mapping)) continue;
                mappingInfoMap.put(((DimensionDataAccess.Mapping)annotation).dimensionType(), MappingInfo.of((DimensionDataAccess.Mapping)annotation));
            }
            return mappingInfoMap;
        });
    }

    static class MappingInfo {
        String dimension;
        String property;
        int idParamIndex;

        static MappingInfo of(DimensionDataAccess.Mapping mapping) {
            return new MappingInfo(mapping.dimensionType(), mapping.property(), mapping.idParamIndex());
        }

        public String getDimension() {
            return this.dimension;
        }

        public String getProperty() {
            return this.property;
        }

        public int getIdParamIndex() {
            return this.idParamIndex;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void setIdParamIndex(int idParamIndex) {
            this.idParamIndex = idParamIndex;
        }

        public MappingInfo(String dimension, String property, int idParamIndex) {
            this.dimension = dimension;
            this.property = property;
            this.idParamIndex = idParamIndex;
        }
    }
}

