/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.hswebframework.web.authorization.basic.web.AuthorizedToken;
import org.hswebframework.web.authorization.basic.web.ParsedToken;
import org.hswebframework.web.authorization.basic.web.UserTokenParser;
import org.hswebframework.web.authorization.token.UserToken;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionIdUserTokenParser
implements UserTokenParser {
    protected UserTokenManager userTokenManager;

    @Autowired
    public void setUserTokenManager(UserTokenManager userTokenManager) {
        this.userTokenManager = userTokenManager;
    }

    @Override
    public ParsedToken parseToken(HttpServletRequest request) {
        final HttpSession session = request.getSession(false);
        if (session != null) {
            final String sessionId = session.getId();
            UserToken token = this.userTokenManager.getByToken(sessionId);
            final long interval = session.getMaxInactiveInterval();
            if (token != null && token.isExpired()) {
                final String userId = token.getUserId();
                return new AuthorizedToken(){

                    @Override
                    public String getUserId() {
                        return userId;
                    }

                    @Override
                    public String getToken() {
                        return sessionId;
                    }

                    @Override
                    public String getType() {
                        return "sessionId";
                    }

                    @Override
                    public long getMaxInactiveInterval() {
                        return interval;
                    }
                };
            }
            return new ParsedToken(){

                @Override
                public String getToken() {
                    return session.getId();
                }

                @Override
                public String getType() {
                    return "sessionId";
                }
            };
        }
        return null;
    }
}

