/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.handler.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.hswebframework.utils.ClassUtils;
import org.hswebframework.web.authorization.access.DataAccessConfig;
import org.hswebframework.web.authorization.access.DataAccessHandler;
import org.hswebframework.web.authorization.access.OwnCreatedDataAccessConfig;
import org.hswebframework.web.authorization.basic.handler.access.InvokeResultUtils;
import org.hswebframework.web.authorization.define.AuthorizingContext;
import org.hswebframework.web.authorization.define.Phased;
import org.hswebframework.web.commons.entity.Entity;
import org.hswebframework.web.commons.entity.RecordCreationEntity;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.controller.QueryController;
import org.hswebframework.web.service.QueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwnCreatedDataAccessHandler
implements DataAccessHandler {
    private static final Logger logger = LoggerFactory.getLogger(OwnCreatedDataAccessHandler.class);

    public boolean isSupport(DataAccessConfig access) {
        return access instanceof OwnCreatedDataAccessConfig;
    }

    public boolean handle(DataAccessConfig access, AuthorizingContext context) {
        OwnCreatedDataAccessConfig own = (OwnCreatedDataAccessConfig)access;
        Object controller = context.getParamContext().getTarget();
        if (controller != null) {
            switch (access.getAction()) {
                case "get": 
                case "query": {
                    return this.doQueryAccess(own, context);
                }
                case "delete": 
                case "update": {
                    return this.doRWAccess(own, context, controller);
                }
                case "add": {
                    return this.putCreatorId(own, context);
                }
            }
            logger.warn("action: {} not support now!", (Object)access.getAction());
        } else {
            logger.warn("target is null!");
        }
        return true;
    }

    public boolean putCreatorId(OwnCreatedDataAccessConfig access, AuthorizingContext context) {
        RecordCreationEntity entity = context.getParamContext().getParams().values().stream().filter(RecordCreationEntity.class::isInstance).map(RecordCreationEntity.class::cast).findAny().orElse(null);
        if (entity != null) {
            entity.setCreatorId(context.getAuthentication().getUser().getId());
        } else {
            logger.warn("try put creatorId property,but not found any RecordCreationEntity!");
        }
        return true;
    }

    protected boolean doRWAccess(OwnCreatedDataAccessConfig access, AuthorizingContext context, Object controller) {
        QueryService queryService;
        RecordCreationEntity oldData;
        Class entityType;
        Object id = context.getParamContext().getParameter(context.getDefinition().getDataAccessDefinition().getIdParameterName()).orElse(null);
        return !(controller instanceof QueryController) || !ClassUtils.instanceOf((Class)(entityType = ClassUtils.getGenericType(controller.getClass(), (int)0)), RecordCreationEntity.class) || (oldData = (RecordCreationEntity)(queryService = (QueryService)((QueryController)controller).getService()).selectByPk(id)) == null || context.getAuthentication().getUser().getId().equals(oldData.getCreatorId());
    }

    protected boolean doQueryAccess(OwnCreatedDataAccessConfig access, AuthorizingContext context) {
        String userId = context.getAuthentication().getUser().getId();
        if (context.getDefinition().getDataAccessDefinition().getPhased() == Phased.before) {
            Entity entity = context.getParamContext().getParams().values().stream().filter(Entity.class::isInstance).map(Entity.class::cast).findAny().orElse(null);
            if (entity == null) {
                logger.warn("try validate query access, but query entity is null or not instance of org.hswebframework.web.commons.entity.Entity");
                return true;
            }
            if (entity instanceof QueryParamEntity) {
                QueryParamEntity queryParamEntity = (QueryParamEntity)entity;
                List oldParam = queryParamEntity.getTerms();
                queryParamEntity.setTerms(new ArrayList());
                queryParamEntity.where("creatorId", (Object)userId).nest().setTerms(oldParam);
            } else if (entity instanceof RecordCreationEntity) {
                ((RecordCreationEntity)entity).setCreatorId(userId);
            } else {
                logger.warn("try validate query access,but entity not support, QueryParamEntity and RecordCreationEntity support now!");
            }
        } else {
            Object result = InvokeResultUtils.convertRealResult(context.getParamContext().getInvokeResult());
            return this.matchCreatorId(result, userId);
        }
        return true;
    }

    protected boolean matchCreatorId(Object result, String userId) {
        if (null == result) {
            return true;
        }
        if (result instanceof RecordCreationEntity) {
            return userId.equals(((RecordCreationEntity)result).getCreatorId());
        }
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            collection.removeAll(collection.stream().filter(o -> !this.matchCreatorId(o, userId)).collect(Collectors.toList()));
        } else {
            try {
                return userId.equals(PropertyUtils.getProperty((Object)result, (String)"creatorId"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }
}

