/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.handler.access;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.hswebframework.web.authorization.access.DataAccessConfig;
import org.hswebframework.web.authorization.access.DataAccessHandler;
import org.hswebframework.web.authorization.access.FieldFilterDataAccessConfig;
import org.hswebframework.web.authorization.basic.handler.access.InvokeResultUtils;
import org.hswebframework.web.authorization.define.AuthorizingContext;
import org.hswebframework.web.authorization.define.Phased;
import org.hswebframework.web.commons.entity.Entity;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.commons.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldFilterDataAccessHandler
implements DataAccessHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean isSupport(DataAccessConfig access) {
        return access instanceof FieldFilterDataAccessConfig;
    }

    public boolean handle(DataAccessConfig access, AuthorizingContext context) {
        FieldFilterDataAccessConfig filterDataAccessConfig = (FieldFilterDataAccessConfig)access;
        switch (access.getAction()) {
            case "query": 
            case "get": {
                return this.doQueryAccess(filterDataAccessConfig, context);
            }
            case "add": 
            case "update": {
                return this.doUpdateAccess(filterDataAccessConfig, context);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("field filter not support for {}", (Object)access.getAction());
        }
        return true;
    }

    protected boolean doUpdateAccess(FieldFilterDataAccessConfig accesses, AuthorizingContext params) {
        Object supportParam;
        Map paramsMap = params.getParamContext().getParams();
        Object object = supportParam = paramsMap.size() == 0 ? paramsMap.values().iterator().next() : paramsMap.values().stream().filter(param -> param instanceof Entity || param instanceof Model || param instanceof Map).findAny().orElse(null);
        if (null != supportParam) {
            for (String field : accesses.getFields()) {
                try {
                    BeanUtilsBean.getInstance().getPropertyUtils().setProperty(supportParam, field, null);
                }
                catch (Exception e) {
                    this.logger.warn("can't set {} null", (Object)field, (Object)e);
                }
            }
        } else {
            this.logger.warn("doUpdateAccess skip ,because can not found any support entity in param!");
        }
        return true;
    }

    protected boolean doQueryAccess(FieldFilterDataAccessConfig access, AuthorizingContext context) {
        if (context.getDefinition().getDataAccessDefinition().getPhased() == Phased.before) {
            QueryParamEntity entity = context.getParamContext().getParams().values().stream().filter(QueryParamEntity.class::isInstance).map(QueryParamEntity.class::cast).findAny().orElse(null);
            if (entity == null) {
                this.logger.warn("try validate query access, but query entity is null or not instance of org.hswebframework.web.commons.entity.Entity");
                return true;
            }
            Set denyFields = access.getFields();
            entity.excludes(denyFields.toArray(new String[denyFields.size()]));
        } else {
            Object result = InvokeResultUtils.convertRealResult(context.getParamContext().getInvokeResult());
            if (result instanceof Collection) {
                ((Collection)result).forEach(o -> this.setObjectPropertyNull(o, access.getFields()));
            } else {
                this.setObjectPropertyNull(result, access.getFields());
            }
        }
        return true;
    }

    protected void setObjectPropertyNull(Object obj, Set<String> fields) {
        if (null == obj) {
            return;
        }
        for (String field : fields) {
            try {
                BeanUtilsBean.getInstance().getPropertyUtils().setProperty(obj, field, null);
            }
            catch (Exception exception) {}
        }
    }
}

