/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hswebframework.web.authorization.define.AuthorizingContext;
import org.hswebframework.web.authorization.define.HandleType;
import org.hswebframework.web.authorization.listener.event.AuthorizingHandleBeforeEvent;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.event.EventListener;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.util.PathMatcher;

@ConfigurationProperties(value="hsweb.authorize")
public class UserAllowPermissionHandler {
    private Map<String, Map<String, String>> allows = new HashMap<String, Map<String, String>>();
    private PathMatcher pathMatcher = new AntPathMatcher(".");

    @EventListener
    public void handEvent(AuthorizingHandleBeforeEvent event) {
        if (this.allows.isEmpty() || event.getHandleType() == HandleType.DATA) {
            return;
        }
        AuthorizingContext context = event.getContext();
        String path = ClassUtils.getUserClass((Object)context.getParamContext().getTarget()).getName().concat(".").concat(context.getParamContext().getMethod().getName());
        String userId = context.getAuthentication().getUser().getId();
        boolean allow = Optional.ofNullable(this.allows.get("users")).map(users -> (String)users.get(userId)).filter(pattern -> "*".equals(pattern) || this.pathMatcher.match(pattern, path)).isPresent();
        if (allow) {
            event.setAllow(true);
            return;
        }
        allow = context.getAuthentication().getRoles().stream().map(role -> (String)this.allows.getOrDefault("roles", Collections.emptyMap()).get(role.getId())).filter(Objects::nonNull).anyMatch(pattern -> "*".equals(pattern) || this.pathMatcher.match(pattern, path));
        if (allow) {
            event.setAllow(true);
            return;
        }
    }

    public Map<String, Map<String, String>> getAllows() {
        return this.allows;
    }

    public void setAllows(Map<String, Map<String, String>> allows) {
        this.allows = allows;
    }
}

