/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.handler;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.expands.script.engine.DynamicScriptEngine;
import org.hswebframework.expands.script.engine.DynamicScriptEngineFactory;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.Permission;
import org.hswebframework.web.authorization.access.DataAccessController;
import org.hswebframework.web.authorization.annotation.Logical;
import org.hswebframework.web.authorization.basic.handler.AuthorizingHandler;
import org.hswebframework.web.authorization.define.AuthorizeDefinition;
import org.hswebframework.web.authorization.define.AuthorizingContext;
import org.hswebframework.web.authorization.define.HandleType;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.authorization.listener.event.AuthorizingHandleBeforeEvent;
import org.hswebframework.web.boost.aop.context.MethodInterceptorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class DefaultAuthorizingHandler
implements AuthorizingHandler {
    private DataAccessController dataAccessController;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ApplicationEventPublisher eventPublisher;

    public DefaultAuthorizingHandler(DataAccessController dataAccessController) {
        this.dataAccessController = dataAccessController;
    }

    public DefaultAuthorizingHandler() {
    }

    public void setDataAccessController(DataAccessController dataAccessController) {
        this.dataAccessController = dataAccessController;
    }

    @Autowired
    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void handRBAC(AuthorizingContext context) {
        if (this.handleEvent(context, HandleType.RBAC)) {
            return;
        }
        this.handleRBAC(context.getAuthentication(), context.getDefinition());
        this.handleExpression(context.getAuthentication(), context.getDefinition(), context.getParamContext());
    }

    private boolean handleEvent(AuthorizingContext context, HandleType type) {
        if (null != this.eventPublisher) {
            AuthorizingHandleBeforeEvent event = new AuthorizingHandleBeforeEvent(context, type);
            this.eventPublisher.publishEvent((ApplicationEvent)event);
            if (!event.isExecute()) {
                if (event.isAllow()) {
                    return true;
                }
                throw new AccessDenyException(event.getMessage());
            }
        }
        return false;
    }

    @Override
    public void handleDataAccess(AuthorizingContext context) {
        if (this.dataAccessController == null) {
            this.logger.warn("dataAccessController is null,skip result access control!");
            return;
        }
        if (context.getDefinition().getDataAccessDefinition() == null) {
            return;
        }
        if (this.handleEvent(context, HandleType.DATA)) {
            return;
        }
        List permission = context.getAuthentication().getPermissions().stream().filter(per -> context.getDefinition().getPermissions().contains(per.getId())).collect(Collectors.toList());
        DataAccessController finalAccessController = this.dataAccessController;
        Set accesses = permission.stream().map(Permission::getDataAccesses).flatMap(Collection::stream).filter(access -> context.getDefinition().getActions().contains(access.getAction())).collect(Collectors.toSet());
        if (accesses.isEmpty()) {
            return;
        }
        Function<Predicate, Boolean> function = accesses.stream()::allMatch;
        boolean isAccess = function.apply(access -> finalAccessController.doAccess(access, context));
        if (!isAccess) {
            throw new AccessDenyException(context.getDefinition().getMessage());
        }
    }

    protected void handleExpression(Authentication authentication, AuthorizeDefinition definition, MethodInterceptorContext paramContext) {
        if (definition.getScript() != null) {
            String scriptId = DigestUtils.md5Hex((String)definition.getScript().getScript());
            DynamicScriptEngine engine = DynamicScriptEngineFactory.getEngine((String)definition.getScript().getLanguage());
            if (null == engine) {
                throw new AccessDenyException("{unknown_engine}:" + definition.getScript().getLanguage());
            }
            if (!engine.compiled(scriptId)) {
                try {
                    engine.compile(scriptId, definition.getScript().getScript());
                }
                catch (Exception e) {
                    this.logger.error("express compile error", (Throwable)e);
                    throw new AccessDenyException("{expression_error}");
                }
            }
            HashMap<String, Authentication> var = new HashMap<String, Authentication>(paramContext.getParams());
            var.put("auth", authentication);
            Object success = engine.execute(scriptId, var).get();
            if (!(success instanceof Boolean) || !((Boolean)success).booleanValue()) {
                throw new AccessDenyException(definition.getMessage());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleRBAC(Authentication authentication, AuthorizeDefinition definition) {
        Function<Predicate, Boolean> func;
        boolean access = true;
        Logical logical = definition.getLogical() == Logical.DEFAULT ? Logical.OR : definition.getLogical();
        boolean logicalIsOr = logical == Logical.OR;
        Set permissionsDef = definition.getPermissions();
        Set actionsDef = definition.getActions();
        Set rolesDef = definition.getRoles();
        Set usersDef = definition.getUser();
        if (!definition.getPermissions().isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u6267\u884c\u6743\u9650\u63a7\u5236:\u6743\u9650{}({}),\u64cd\u4f5c{}.", new Object[]{definition.getPermissionDescription(), permissionsDef, actionsDef});
            }
            List permissions = authentication.getPermissions().stream().filter(permission -> {
                if (!permissionsDef.contains(permission.getId())) {
                    return false;
                }
                if (actionsDef.isEmpty()) {
                    return true;
                }
                List actions = permission.getActions().stream().filter(actionsDef::contains).collect(Collectors.toList());
                if (actions.isEmpty()) {
                    return false;
                }
                return logicalIsOr || permission.getActions().containsAll(actions);
            }).collect(Collectors.toList());
            boolean bl = logicalIsOr ? CollectionUtils.isNotEmpty(permissions) : (access = permissions.size() == permissionsDef.size());
        }
        if (!rolesDef.isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("do role access handle : roles{} , definition:{}", (Object)rolesDef, (Object)definition.getRoles());
            }
            Function<Predicate, Boolean> function = logicalIsOr ? authentication.getRoles().stream()::anyMatch : (func = authentication.getRoles().stream()::allMatch);
            boolean bl = logicalIsOr ? access || func.apply(role -> rolesDef.contains(role.getId())).booleanValue() : (access = access && func.apply(role -> rolesDef.contains(role.getId())) != false);
        }
        if (!usersDef.isEmpty()) {
            boolean bl;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("do user access handle : users{} , definition:{} ", (Object)usersDef, (Object)definition.getUser());
            }
            Function<Predicate, Boolean> function = logicalIsOr ? usersDef.stream()::anyMatch : (func = usersDef.stream()::allMatch);
            if (logicalIsOr) {
                if (access) return;
                if (func.apply(authentication.getUser().getUsername()::equals).booleanValue()) {
                    return;
                }
                bl = false;
            } else {
                if (access) {
                    if (func.apply(authentication.getUser().getUsername()::equals).booleanValue()) {
                        return;
                    }
                }
                bl = false;
            }
            access = bl;
        }
        if (access) return;
        throw new AccessDenyException(definition.getMessage());
    }
}

