/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.embed;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationManager;
import org.hswebframework.web.authorization.AuthenticationRequest;
import org.hswebframework.web.authorization.basic.embed.EmbedAuthenticationProperties;
import org.hswebframework.web.authorization.builder.DataAccessConfigBuilderFactory;
import org.hswebframework.web.authorization.simple.PlainTextUsernamePasswordAuthenticationRequest;
import org.hswebframework.web.authorization.simple.builder.SimpleDataAccessConfigBuilderFactory;
import org.hswebframework.web.validate.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.annotation.Order;

@ConfigurationProperties(prefix="hsweb")
@Order(value=-2147483648)
public class EmbedAuthenticationManager
implements AuthenticationManager {
    private Map<String, Authentication> authentications = new HashMap<String, Authentication>();
    @Autowired(required=false)
    private DataAccessConfigBuilderFactory dataAccessConfigBuilderFactory = new SimpleDataAccessConfigBuilderFactory();
    private Map<String, EmbedAuthenticationProperties> users = new HashMap<String, EmbedAuthenticationProperties>();

    @PostConstruct
    public void init() {
        this.users.forEach((id, properties) -> {
            if (org.springframework.util.StringUtils.isEmpty((Object)properties.getId())) {
                properties.setId((String)id);
            }
            for (EmbedAuthenticationProperties.PermissionInfo permissionInfo : properties.getPermissions()) {
                for (Map<String, Object> objectMap : permissionInfo.getDataAccesses()) {
                    for (Map.Entry<String, Object> stringObjectEntry : objectMap.entrySet()) {
                        Map mapVal;
                        boolean maybeIsList;
                        if (!(stringObjectEntry.getValue() instanceof Map) || !(maybeIsList = (mapVal = (Map)stringObjectEntry.getValue()).keySet().stream().allMatch(StringUtils::isInt))) continue;
                        stringObjectEntry.setValue(mapVal.values());
                    }
                }
            }
            this.authentications.put((String)id, properties.toAuthentication(this.dataAccessConfigBuilderFactory));
        });
    }

    public Authentication authenticate(AuthenticationRequest request) {
        if (request instanceof PlainTextUsernamePasswordAuthenticationRequest) {
            return this.sync(this.users.values().stream().filter(user -> ((PlainTextUsernamePasswordAuthenticationRequest)request).getUsername().equals(user.getUsername()) && ((PlainTextUsernamePasswordAuthenticationRequest)request).getPassword().equals(user.getPassword())).findFirst().map(properties -> this.authentications.get(properties.getId())).orElseThrow(() -> new ValidationException("\u7528\u6237\u4e0d\u5b58\u5728")));
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6388\u6743\u7c7b\u578b:" + request);
    }

    public Authentication getByUserId(String userId) {
        return this.authentications.get(userId);
    }

    public Authentication sync(Authentication authentication) {
        this.authentications.put(authentication.getUser().getId(), authentication);
        return authentication;
    }

    void addAuthentication(Authentication authentication) {
        this.sync(authentication);
    }

    public Map<String, EmbedAuthenticationProperties> getUsers() {
        return this.users;
    }

    public void setUsers(Map<String, EmbedAuthenticationProperties> users) {
        this.users = users;
    }
}

