/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.define;

import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hswebframework.web.authorization.access.DataAccessController;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.Logical;
import org.hswebframework.web.authorization.annotation.RequiresDataAccess;
import org.hswebframework.web.authorization.annotation.RequiresExpression;
import org.hswebframework.web.authorization.basic.define.DefaultDataAccessDefinition;
import org.hswebframework.web.authorization.basic.define.DefaultScript;
import org.hswebframework.web.authorization.define.AopAuthorizeDefinition;
import org.hswebframework.web.authorization.define.DataAccessDefinition;
import org.hswebframework.web.authorization.define.Phased;
import org.hswebframework.web.authorization.define.Script;

public class DefaultBasicAuthorizeDefinition
implements AopAuthorizeDefinition {
    private boolean dataAccessControl;
    private String[] permissionDescription = new String[0];
    private String[] actionDescription = new String[0];
    private Set<String> permissions = new LinkedHashSet<String>();
    private Set<String> actions = new LinkedHashSet<String>();
    private Set<String> roles = new LinkedHashSet<String>();
    private Set<String> user = new LinkedHashSet<String>();
    private Script script;
    private String message = "{un_authorized}";
    private Logical logical = Logical.DEFAULT;
    private DataAccessDefinition dataAccessDefinition;
    private Phased phased = Phased.before;
    private Class targetClass;
    private Method targetMethod;

    public Phased getPhased() {
        return this.phased;
    }

    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    public boolean isEmpty() {
        return this.permissions.isEmpty() && this.roles.isEmpty() && this.user.isEmpty() && this.script == null && this.dataAccessDefinition == null;
    }

    public void put(Authorize authorize) {
        if (null == authorize || authorize.ignore()) {
            return;
        }
        this.permissions.addAll(Arrays.asList(authorize.permission()));
        this.actions.addAll(Arrays.asList(authorize.action()));
        this.roles.addAll(Arrays.asList(authorize.role()));
        this.user.addAll(Arrays.asList(authorize.user()));
        if (authorize.logical() != Logical.DEFAULT) {
            this.logical = authorize.logical();
        }
        this.message = authorize.message();
        this.phased = authorize.phased();
        this.put(authorize.dataAccess());
    }

    public void put(RequiresExpression expression) {
        if (null == expression) {
            return;
        }
        this.script = new DefaultScript(expression.language(), expression.value());
    }

    public void put(RequiresDataAccess dataAccess) {
        if (null == dataAccess || dataAccess.ignore()) {
            return;
        }
        if (!"".equals(dataAccess.permission())) {
            this.permissions.add(dataAccess.permission());
        }
        this.actions.addAll(Arrays.asList(dataAccess.action()));
        DefaultDataAccessDefinition definition = new DefaultDataAccessDefinition();
        definition.setEntityType(dataAccess.entityType());
        definition.setPhased(dataAccess.phased());
        if (!"".equals(dataAccess.controllerBeanName())) {
            definition.setController(dataAccess.controllerBeanName());
        } else if (DataAccessController.class != dataAccess.controllerClass()) {
            definition.setController(dataAccess.getClass().getName());
        }
        this.dataAccessDefinition = definition;
        this.dataAccessControl = true;
    }

    public boolean isDataAccessControl() {
        return this.dataAccessControl;
    }

    public String[] getPermissionDescription() {
        return this.permissionDescription;
    }

    public String[] getActionDescription() {
        return this.actionDescription;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public Set<String> getActions() {
        return this.actions;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Set<String> getUser() {
        return this.user;
    }

    public Script getScript() {
        return this.script;
    }

    public String getMessage() {
        return this.message;
    }

    public Logical getLogical() {
        return this.logical;
    }

    public DataAccessDefinition getDataAccessDefinition() {
        return this.dataAccessDefinition;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    public void setDataAccessControl(boolean dataAccessControl) {
        this.dataAccessControl = dataAccessControl;
    }

    public void setPermissionDescription(String[] permissionDescription) {
        this.permissionDescription = permissionDescription;
    }

    public void setActionDescription(String[] actionDescription) {
        this.actionDescription = actionDescription;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public void setActions(Set<String> actions) {
        this.actions = actions;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void setUser(Set<String> user) {
        this.user = user;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setLogical(Logical logical) {
        this.logical = logical;
    }

    public void setDataAccessDefinition(DataAccessDefinition dataAccessDefinition) {
        this.dataAccessDefinition = dataAccessDefinition;
    }

    public void setPhased(Phased phased) {
        this.phased = phased;
    }

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public void setTargetMethod(Method targetMethod) {
        this.targetMethod = targetMethod;
    }

    public DefaultBasicAuthorizeDefinition() {
    }

    @ConstructorProperties(value={"dataAccessControl", "permissionDescription", "actionDescription", "permissions", "actions", "roles", "user", "script", "message", "logical", "dataAccessDefinition", "phased", "targetClass", "targetMethod"})
    public DefaultBasicAuthorizeDefinition(boolean dataAccessControl, String[] permissionDescription, String[] actionDescription, Set<String> permissions, Set<String> actions, Set<String> roles, Set<String> user, Script script, String message, Logical logical, DataAccessDefinition dataAccessDefinition, Phased phased, Class targetClass, Method targetMethod) {
        this.dataAccessControl = dataAccessControl;
        this.permissionDescription = permissionDescription;
        this.actionDescription = actionDescription;
        this.permissions = permissions;
        this.actions = actions;
        this.roles = roles;
        this.user = user;
        this.script = script;
        this.message = message;
        this.logical = logical;
        this.dataAccessDefinition = dataAccessDefinition;
        this.phased = phased;
        this.targetClass = targetClass;
        this.targetMethod = targetMethod;
    }

    public String toString() {
        return "DefaultBasicAuthorizeDefinition(dataAccessControl=" + this.isDataAccessControl() + ", permissionDescription=" + Arrays.deepToString(this.getPermissionDescription()) + ", actionDescription=" + Arrays.deepToString(this.getActionDescription()) + ", permissions=" + this.getPermissions() + ", actions=" + this.getActions() + ", roles=" + this.getRoles() + ", user=" + this.getUser() + ", script=" + this.getScript() + ", message=" + this.getMessage() + ", logical=" + this.getLogical() + ", dataAccessDefinition=" + this.getDataAccessDefinition() + ", phased=" + this.getPhased() + ", targetClass=" + this.getTargetClass() + ", targetMethod=" + this.getTargetMethod() + ")";
    }
}

