/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.configuration;

import java.util.List;
import org.hswebframework.web.authorization.AuthenticationManager;
import org.hswebframework.web.authorization.access.DataAccessController;
import org.hswebframework.web.authorization.access.DataAccessHandler;
import org.hswebframework.web.authorization.basic.aop.AopMethodAuthorizeDefinitionParser;
import org.hswebframework.web.authorization.basic.configuration.BasicAuthorizationTokenParser;
import org.hswebframework.web.authorization.basic.embed.EmbedAuthenticationManager;
import org.hswebframework.web.authorization.basic.handler.DefaultAuthorizingHandler;
import org.hswebframework.web.authorization.basic.handler.UserAllowPermissionHandler;
import org.hswebframework.web.authorization.basic.handler.access.DefaultDataAccessController;
import org.hswebframework.web.authorization.basic.twofactor.TwoFactorHandlerInterceptorAdapter;
import org.hswebframework.web.authorization.basic.web.AuthorizationController;
import org.hswebframework.web.authorization.basic.web.SessionIdUserTokenGenerator;
import org.hswebframework.web.authorization.basic.web.SessionIdUserTokenParser;
import org.hswebframework.web.authorization.basic.web.UserOnSignIn;
import org.hswebframework.web.authorization.basic.web.UserOnSignOut;
import org.hswebframework.web.authorization.basic.web.UserTokenController;
import org.hswebframework.web.authorization.basic.web.UserTokenForTypeParser;
import org.hswebframework.web.authorization.basic.web.UserTokenParser;
import org.hswebframework.web.authorization.basic.web.WebUserTokenInterceptor;
import org.hswebframework.web.authorization.basic.web.session.UserTokenAutoExpiredListener;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.authorization.twofactor.TwoFactorValidatorManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class AuthorizingHandlerAutoConfiguration {
    @Bean
    public DefaultDataAccessController dataAccessController() {
        return new DefaultDataAccessController();
    }

    @Bean
    public DefaultAuthorizingHandler authorizingHandler(DataAccessController dataAccessController) {
        return new DefaultAuthorizingHandler(dataAccessController);
    }

    @Bean
    @ConditionalOnMissingBean(value={UserTokenParser.class})
    public UserTokenParser userTokenParser() {
        return new SessionIdUserTokenParser();
    }

    @Bean
    public SessionIdUserTokenGenerator sessionIdUserTokenGenerator() {
        return new SessionIdUserTokenGenerator();
    }

    @Bean
    @ConditionalOnProperty(prefix="hsweb.authorize.two-factor", name={"enable"}, havingValue="true")
    @Order(value=100)
    public WebMvcConfigurer twoFactorHandlerConfigurer(final TwoFactorValidatorManager manager) {
        return new WebMvcConfigurerAdapter(){

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addInterceptor((HandlerInterceptor)new TwoFactorHandlerInterceptorAdapter(manager));
                super.addInterceptors(registry);
            }
        };
    }

    @Bean
    @Order(value=-2147483648)
    public WebMvcConfigurer webUserTokenInterceptorConfigurer(final UserTokenManager userTokenManager, final AopMethodAuthorizeDefinitionParser parser, final List<UserTokenParser> userTokenParser) {
        return new WebMvcConfigurerAdapter(){

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addInterceptor((HandlerInterceptor)new WebUserTokenInterceptor(userTokenManager, userTokenParser, parser));
                super.addInterceptors(registry);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthenticationManager.class})
    public AuthenticationManager embedAuthenticationManager() {
        return new EmbedAuthenticationManager();
    }

    @Bean
    public UserAllowPermissionHandler userAllowPermissionHandler() {
        return new UserAllowPermissionHandler();
    }

    @Bean
    public UserOnSignIn userOnSignIn(UserTokenManager userTokenManager) {
        return new UserOnSignIn(userTokenManager);
    }

    @Bean
    public UserOnSignOut userOnSignOut(UserTokenManager userTokenManager) {
        return new UserOnSignOut(userTokenManager);
    }

    @Bean
    public UserTokenAutoExpiredListener userTokenAutoExpiredListener(UserTokenManager userTokenManager) {
        return new UserTokenAutoExpiredListener(userTokenManager);
    }

    @Bean
    public AuthorizationController authorizationController() {
        return new AuthorizationController();
    }

    @Bean
    public UserTokenController userTokenController() {
        return new UserTokenController();
    }

    @Configuration
    @ConditionalOnProperty(prefix="hsweb.authorize", name={"basic-authorization"}, havingValue="true")
    @ConditionalOnClass(value={UserTokenForTypeParser.class})
    public static class BasicAuthorizationConfiguration {
        @Bean
        public BasicAuthorizationTokenParser basicAuthorizationTokenParser(AuthenticationManager authenticationManager, UserTokenManager tokenManager) {
            return new BasicAuthorizationTokenParser(authenticationManager, tokenManager);
        }
    }

    @Configuration
    public static class DataAccessHandlerProcessor
    implements BeanPostProcessor {
        @Autowired
        private DefaultDataAccessController defaultDataAccessController;

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (bean instanceof DataAccessHandler) {
                this.defaultDataAccessController.addHandler((DataAccessHandler)bean);
            }
            return bean;
        }
    }
}

