/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.aop;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hswebframework.web.AopUtils;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.RequiresDataAccess;
import org.hswebframework.web.authorization.annotation.RequiresExpression;
import org.hswebframework.web.authorization.basic.aop.AopMethodAuthorizeDefinitionCustomizerParser;
import org.hswebframework.web.authorization.basic.aop.AopMethodAuthorizeDefinitionParser;
import org.hswebframework.web.authorization.basic.define.DefaultBasicAuthorizeDefinition;
import org.hswebframework.web.authorization.basic.define.EmptyAuthorizeDefinition;
import org.hswebframework.web.authorization.define.AuthorizeDefinition;
import org.hswebframework.web.boost.aop.context.MethodInterceptorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class DefaultAopMethodAuthorizeDefinitionParser
implements AopMethodAuthorizeDefinitionParser {
    private static final Logger log = LoggerFactory.getLogger(DefaultAopMethodAuthorizeDefinitionParser.class);
    private Map<CacheKey, AuthorizeDefinition> cache = new ConcurrentHashMap<CacheKey, AuthorizeDefinition>();
    private List<AopMethodAuthorizeDefinitionCustomizerParser> parserCustomizers;
    private static Set<String> excludeMethodName = new HashSet<String>(Arrays.asList("toString", "clone", "hashCode", "getClass"));

    @Autowired(required=false)
    public void setParserCustomizers(List<AopMethodAuthorizeDefinitionCustomizerParser> parserCustomizers) {
        this.parserCustomizers = parserCustomizers;
    }

    @Override
    public List<AuthorizeDefinition> getAllParsed() {
        return new ArrayList<AuthorizeDefinition>(this.cache.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthorizeDefinition parse(Class target, Method method, MethodInterceptorContext context) {
        if (excludeMethodName.contains(method.getName())) {
            return null;
        }
        CacheKey key = this.buildCacheKey(target, method);
        AuthorizeDefinition definition = this.cache.get(key);
        if (definition instanceof EmptyAuthorizeDefinition) {
            return null;
        }
        if (null != definition) {
            return definition;
        }
        if (!CollectionUtils.isEmpty(this.parserCustomizers)) {
            definition = this.parserCustomizers.stream().map(customizer -> customizer.parse(target, method, context)).filter(Objects::nonNull).findAny().orElse(null);
            if (definition instanceof EmptyAuthorizeDefinition) {
                return null;
            }
            if (definition != null) {
                return definition;
            }
        }
        Authorize classAuth = (Authorize)AopUtils.findAnnotation((Class)target, Authorize.class);
        Authorize methodAuth = (Authorize)AopUtils.findMethodAnnotation((Class)target, (Method)method, Authorize.class);
        RequiresDataAccess classDataAccess = (RequiresDataAccess)AopUtils.findAnnotation((Class)target, RequiresDataAccess.class);
        RequiresDataAccess methodDataAccess = (RequiresDataAccess)AopUtils.findMethodAnnotation((Class)target, (Method)method, RequiresDataAccess.class);
        RequiresExpression expression = (RequiresExpression)AopUtils.findAnnotation((Class)target, RequiresExpression.class);
        if (classAuth == null && methodAuth == null && classDataAccess == null && methodDataAccess == null && expression == null) {
            this.cache.put(key, EmptyAuthorizeDefinition.instance);
            return null;
        }
        if (methodAuth != null && methodAuth.ignore() || classAuth != null && classAuth.ignore()) {
            this.cache.put(key, EmptyAuthorizeDefinition.instance);
            return null;
        }
        Map<CacheKey, AuthorizeDefinition> map = this.cache;
        synchronized (map) {
            DefaultBasicAuthorizeDefinition authorizeDefinition = new DefaultBasicAuthorizeDefinition();
            authorizeDefinition.setTargetClass(target);
            authorizeDefinition.setTargetMethod(method);
            if (methodAuth == null || methodAuth.merge()) {
                authorizeDefinition.put(classAuth);
            }
            authorizeDefinition.put(methodAuth);
            authorizeDefinition.put(expression);
            authorizeDefinition.put(classDataAccess);
            authorizeDefinition.put(methodDataAccess);
            if (authorizeDefinition.getPermissionDescription().length == 0 && classAuth != null) {
                authorizeDefinition.put(classAuth.dataAccess());
                String[] desc = classAuth.description();
                if (desc.length > 0) {
                    authorizeDefinition.setPermissionDescription(desc);
                }
            }
            if (authorizeDefinition.getActionDescription().length == 0 && methodAuth != null && methodAuth.description().length != 0) {
                authorizeDefinition.setActionDescription(methodAuth.description());
            }
            log.info("parsed authorizeDefinition {}.{} => {}.{} permission:{} actions:{}", new Object[]{target.getSimpleName(), method.getName(), authorizeDefinition.getPermissionDescription(), authorizeDefinition.getActionDescription(), authorizeDefinition.getPermissions(), authorizeDefinition.getActions()});
            this.cache.put(key, (AuthorizeDefinition)authorizeDefinition);
            return authorizeDefinition;
        }
    }

    public CacheKey buildCacheKey(Class target, Method method) {
        return new CacheKey(ClassUtils.getUserClass((Class)target), method);
    }

    public void destroy() {
        this.cache.clear();
    }

    class CacheKey {
        private Class type;
        private Method method;

        public CacheKey(Class type, Method method) {
            this.type = type;
            this.method = method;
        }

        public int hashCode() {
            return Arrays.asList(this.type, this.method).hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.hashCode() == obj.hashCode();
        }
    }
}

