/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.aop;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hswebframework.web.AopUtils;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.basic.aop.AopMethodAuthorizeDefinitionParser;
import org.hswebframework.web.authorization.basic.aop.DefaultAopMethodAuthorizeDefinitionParser;
import org.hswebframework.web.authorization.basic.handler.AuthorizingHandler;
import org.hswebframework.web.authorization.define.AuthorizeDefinition;
import org.hswebframework.web.authorization.define.AuthorizeDefinitionInitializedEvent;
import org.hswebframework.web.authorization.define.AuthorizingContext;
import org.hswebframework.web.authorization.define.Phased;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.boost.aop.context.MethodInterceptorContext;
import org.hswebframework.web.boost.aop.context.MethodInterceptorHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;

public class AopAuthorizingController
extends StaticMethodMatcherPointcutAdvisor
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(AopAuthorizingController.class);
    private static final long serialVersionUID = 1154190623020670672L;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    private DefaultAopMethodAuthorizeDefinitionParser defaultParser = new DefaultAopMethodAuthorizeDefinitionParser();
    private boolean autoParse = false;

    public void setAutoParse(boolean autoParse) {
        this.autoParse = autoParse;
    }

    public AopAuthorizingController(AuthorizingHandler authorizingHandler, AopMethodAuthorizeDefinitionParser aopMethodAuthorizeDefinitionParser) {
        super((Advice)((MethodInterceptor)methodInvocation -> {
            MethodInterceptorHolder holder = MethodInterceptorHolder.create((MethodInvocation)methodInvocation);
            MethodInterceptorContext paramContext = holder.createParamContext();
            AuthorizeDefinition definition = aopMethodAuthorizeDefinitionParser.parse(methodInvocation.getThis().getClass(), methodInvocation.getMethod(), paramContext);
            Object result = null;
            boolean isControl = false;
            if (null != definition) {
                Authentication authentication = (Authentication)Authentication.current().orElseThrow(UnAuthorizedException::new);
                AuthorizingContext context = new AuthorizingContext();
                context.setAuthentication(authentication);
                context.setDefinition(definition);
                context.setParamContext(paramContext);
                isControl = true;
                Phased dataAccessPhased = null;
                if (definition.getDataAccessDefinition() != null) {
                    dataAccessPhased = definition.getDataAccessDefinition().getPhased();
                }
                if (definition.getPhased() == Phased.before) {
                    authorizingHandler.handRBAC(context);
                    if (dataAccessPhased == Phased.before) {
                        authorizingHandler.handleDataAccess(context);
                    }
                    result = methodInvocation.proceed();
                    if (dataAccessPhased == Phased.after) {
                        context.setParamContext(holder.createParamContext(result));
                        authorizingHandler.handleDataAccess(context);
                    }
                } else {
                    if (dataAccessPhased == Phased.before) {
                        authorizingHandler.handleDataAccess(context);
                    }
                    result = methodInvocation.proceed();
                    context.setParamContext(holder.createParamContext(result));
                    authorizingHandler.handRBAC(context);
                    if (dataAccessPhased == Phased.after) {
                        authorizingHandler.handleDataAccess(context);
                    }
                }
            }
            if (!isControl) {
                result = methodInvocation.proceed();
            }
            return result;
        }));
    }

    public boolean matches(Method method, Class<?> aClass) {
        boolean support;
        boolean bl = support = AopUtils.findAnnotation(aClass, Controller.class) != null || AopUtils.findAnnotation(aClass, RestController.class) != null || AopUtils.findAnnotation(aClass, (Method)method, Authorize.class) != null;
        if (support && this.autoParse) {
            this.defaultParser.parse(aClass, method);
        }
        return support;
    }

    public void run(String ... args) throws Exception {
        if (this.autoParse) {
            List definitions = this.defaultParser.getAllParsed().stream().filter(def -> !def.isEmpty()).collect(Collectors.toList());
            log.info("publish AuthorizeDefinitionInitializedEvent,definition size:{}", (Object)definitions.size());
            this.eventPublisher.publishEvent((ApplicationEvent)new AuthorizeDefinitionInitializedEvent(definitions));
            this.defaultParser.destroy();
        }
    }
}

