/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.token.redis;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.authorization.token.AllopatricLoginMode;
import org.hswebframework.web.authorization.token.TokenState;
import org.hswebframework.web.authorization.token.UserToken;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.authorization.token.redis.SimpleUserToken;
import org.springframework.data.redis.core.ReactiveHashOperations;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.data.redis.core.ReactiveSetOperations;
import org.springframework.data.redis.core.ScanOptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedisUserTokenManager
implements UserTokenManager {
    private final ReactiveRedisOperations<Object, Object> operations;
    private final ReactiveHashOperations<Object, String, Object> userTokenStore;
    private final ReactiveSetOperations<Object, Object> userTokenMapping;
    private Map<String, AllopatricLoginMode> allopatricLoginModes = new HashMap<String, AllopatricLoginMode>();
    private AllopatricLoginMode allopatricLoginMode = AllopatricLoginMode.allow;

    public RedisUserTokenManager(ReactiveRedisOperations<Object, Object> operations) {
        this.operations = operations;
        this.userTokenStore = operations.opsForHash();
        this.userTokenMapping = operations.opsForSet();
    }

    private String getTokenRedisKey(String key) {
        return "user-token:".concat(key);
    }

    private String getUserRedisKey(String key) {
        return "user-token-user:".concat(key);
    }

    @Override
    public Mono<UserToken> getByToken(String token) {
        return this.userTokenStore.entries((Object)this.getTokenRedisKey(token)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).filter(map -> !map.isEmpty()).map(SimpleUserToken::of);
    }

    @Override
    public Flux<UserToken> getByUserId(String userId) {
        String redisKey = this.getUserRedisKey(userId);
        return this.userTokenMapping.members((Object)redisKey).map(String::valueOf).flatMap(token -> this.getByToken((String)token).switchIfEmpty(Mono.defer(() -> this.userTokenMapping.remove((Object)redisKey, new Object[]{token}).then(Mono.empty()))));
    }

    @Override
    public Mono<Boolean> userIsLoggedIn(String userId) {
        return this.getByUserId(userId).hasElements();
    }

    @Override
    public Mono<Boolean> tokenIsLoggedIn(String token) {
        return this.operations.hasKey((Object)this.getTokenRedisKey(token));
    }

    @Override
    public Mono<Integer> totalUser() {
        return this.totalToken();
    }

    @Override
    public Mono<Integer> totalToken() {
        return this.operations.scan(ScanOptions.scanOptions().match("user-token:*").build()).count().map(Long::intValue);
    }

    @Override
    public Flux<UserToken> allLoggedUser() {
        return this.operations.scan(ScanOptions.scanOptions().match("user-token:*").build()).map(String::valueOf).flatMap(this::getByToken);
    }

    @Override
    public Mono<Void> signOutByUserId(String userId) {
        String key = this.getUserRedisKey(userId);
        return ((Mono)this.getByUserId(key).map(UserToken::getToken).map(this::getTokenRedisKey).concatWithValues((Object[])new String[]{key}).as(xva$0 -> this.operations.delete(new Object[]{xva$0}))).then();
    }

    @Override
    public Mono<Void> signOutByToken(String token) {
        return this.getByToken(token).flatMap(t -> this.operations.delete(new Object[]{this.getTokenRedisKey(t.getToken())}).then(this.userTokenMapping.remove((Object)this.getUserRedisKey(t.getToken()), new Object[]{token}))).then();
    }

    @Override
    public Mono<Void> changeUserState(String userId, TokenState state) {
        return this.getByUserId(userId).flatMap(token -> this.changeTokenState(token.getToken(), state)).then();
    }

    @Override
    public Mono<Void> changeTokenState(String token, TokenState state) {
        return this.userTokenStore.put((Object)this.getTokenRedisKey(token), (Object)"state", (Object)state.getValue()).then();
    }

    @Override
    public Mono<UserToken> signIn(String token, String type, String userId, long maxInactiveInterval) {
        return Mono.defer(() -> {
            Mono doSign = Mono.defer(() -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("token", token);
                map.put("type", type);
                map.put("userId", userId);
                map.put("maxInactiveInterval", maxInactiveInterval);
                map.put("state", TokenState.normal.getValue());
                map.put("signInTime", System.currentTimeMillis());
                map.put("lastRequestTime", System.currentTimeMillis());
                String key = this.getTokenRedisKey(token);
                return this.userTokenStore.putAll((Object)key, map).then(Mono.defer(() -> {
                    if (maxInactiveInterval > 0L) {
                        return this.operations.expire((Object)key, Duration.ofMillis(maxInactiveInterval));
                    }
                    return Mono.empty();
                })).then(this.userTokenMapping.add((Object)this.getUserRedisKey(userId), new Object[]{token})).thenReturn((Object)SimpleUserToken.of(map));
            });
            AllopatricLoginMode mode = this.allopatricLoginModes.getOrDefault(type, this.allopatricLoginMode);
            if (mode == AllopatricLoginMode.deny) {
                return this.userIsLoggedIn(userId).flatMap(r -> {
                    if (r.booleanValue()) {
                        return Mono.error((Throwable)new AccessDenyException("\u5df2\u5728\u5176\u4ed6\u5730\u65b9\u767b\u5f55", TokenState.deny.getValue(), null));
                    }
                    return doSign;
                });
            }
            if (mode == AllopatricLoginMode.offlineOther) {
                return this.getByUserId(userId).flatMap(userToken -> {
                    if (type.equals(userToken.getType())) {
                        return this.changeTokenState(userToken.getToken(), TokenState.offline);
                    }
                    return Mono.empty();
                }).then(doSign);
            }
            return doSign;
        });
    }

    @Override
    public Mono<Void> touch(String token) {
        return this.getByToken(token).flatMap(userToken -> {
            if (userToken.getMaxInactiveInterval() > 0L) {
                return this.operations.expire((Object)this.getTokenRedisKey(token), Duration.ofMillis(userToken.getMaxInactiveInterval())).then();
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<Void> checkExpiredToken() {
        return this.operations.scan(ScanOptions.scanOptions().match("user-token-user:*").build()).map(String::valueOf).flatMap(key -> this.userTokenMapping.members(key).map(String::valueOf).flatMap(token -> this.operations.hasKey((Object)this.getTokenRedisKey((String)token)).flatMap(exists -> {
            if (!exists.booleanValue()) {
                return this.userTokenMapping.remove(key, new Object[]{token});
            }
            return Mono.empty();
        }))).then();
    }

    public Map<String, AllopatricLoginMode> getAllopatricLoginModes() {
        return this.allopatricLoginModes;
    }

    public void setAllopatricLoginModes(Map<String, AllopatricLoginMode> allopatricLoginModes) {
        this.allopatricLoginModes = allopatricLoginModes;
    }

    public AllopatricLoginMode getAllopatricLoginMode() {
        return this.allopatricLoginMode;
    }

    public void setAllopatricLoginMode(AllopatricLoginMode allopatricLoginMode) {
        this.allopatricLoginMode = allopatricLoginMode;
    }
}

