/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.define;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.web.authorization.Permission;
import org.hswebframework.web.authorization.annotation.Logical;
import org.hswebframework.web.authorization.define.Phased;
import org.hswebframework.web.authorization.define.ResourceActionDefinition;
import org.hswebframework.web.authorization.define.ResourceDefinition;

public class ResourcesDefinition {
    private Set<ResourceDefinition> resources = new HashSet<ResourceDefinition>();
    private Logical logical = Logical.DEFAULT;
    private Phased phased = Phased.before;

    public void addResource(ResourceDefinition resource, boolean merge) {
        ResourceDefinition definition = this.getResource(resource.getId()).orElse(null);
        if (definition != null) {
            if (merge) {
                resource.getActions().stream().map(ResourceActionDefinition::copy).forEach(definition::addAction);
            } else {
                this.resources.remove(definition);
            }
        }
        this.resources.add(resource.copy());
    }

    public Optional<ResourceDefinition> getResource(String id) {
        return this.resources.stream().filter(resource -> resource.getId().equals(id)).findAny();
    }

    @JsonIgnore
    public List<ResourceDefinition> getDataAccessResources() {
        return this.resources.stream().filter(ResourceDefinition::hasDataAccessAction).collect(Collectors.toList());
    }

    public boolean hasPermission(Permission permission) {
        if (CollectionUtils.isEmpty(this.resources)) {
            return true;
        }
        return this.getResource(permission.getId()).filter(resource -> resource.hasAction(permission.getActions())).isPresent();
    }

    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    public boolean hasPermission(Collection<Permission> permissions) {
        if (CollectionUtils.isEmpty(this.resources)) {
            return true;
        }
        if (CollectionUtils.isEmpty(permissions)) {
            return false;
        }
        if (permissions.size() == 1) {
            return this.hasPermission(permissions.iterator().next());
        }
        Map mappings = permissions.stream().collect(Collectors.toMap(Permission::getId, Function.identity()));
        if (this.logical == Logical.AND) {
            return this.resources.stream().allMatch(resource -> Optional.ofNullable(mappings.get(resource.getId())).map(per -> resource.hasAction(per.getActions())).orElse(false));
        }
        return this.resources.stream().anyMatch(resource -> Optional.ofNullable(mappings.get(resource.getId())).map(per -> resource.hasAction(per.getActions())).orElse(false));
    }

    public Set<ResourceDefinition> getResources() {
        return this.resources;
    }

    public Logical getLogical() {
        return this.logical;
    }

    public Phased getPhased() {
        return this.phased;
    }

    public void setResources(Set<ResourceDefinition> resources) {
        this.resources = resources;
    }

    public void setLogical(Logical logical) {
        this.logical = logical;
    }

    public void setPhased(Phased phased) {
        this.phased = phased;
    }
}

