/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.simple;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Set;
import org.hswebframework.web.authorization.Permission;
import org.hswebframework.web.authorization.access.DataAccessConfig;

public class SimplePermission
implements Permission {
    private static final long serialVersionUID = 7587266693680162184L;
    private String id;
    private String name;
    private Set<String> actions;
    private Set<DataAccessConfig> dataAccesses;

    @Override
    public Set<String> getActions() {
        if (this.actions == null) {
            this.actions = new HashSet<String>();
        }
        return this.actions;
    }

    @Override
    public Set<DataAccessConfig> getDataAccesses() {
        if (this.dataAccesses == null) {
            this.dataAccesses = new HashSet<DataAccessConfig>();
        }
        return this.dataAccesses;
    }

    @Override
    public Permission copy() {
        SimplePermission permission = new SimplePermission();
        permission.setId(this.id);
        permission.setName(this.name);
        permission.setActions(new HashSet<String>(this.getActions()));
        permission.setDataAccesses(new HashSet<DataAccessConfig>(this.getDataAccesses()));
        return permission;
    }

    public static SimplePermissionBuilder builder() {
        return new SimplePermissionBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setActions(Set<String> actions) {
        this.actions = actions;
    }

    public void setDataAccesses(Set<DataAccessConfig> dataAccesses) {
        this.dataAccesses = dataAccesses;
    }

    public SimplePermission() {
    }

    @ConstructorProperties(value={"id", "name", "actions", "dataAccesses"})
    public SimplePermission(String id, String name, Set<String> actions, Set<DataAccessConfig> dataAccesses) {
        this.id = id;
        this.name = name;
        this.actions = actions;
        this.dataAccesses = dataAccesses;
    }

    public static class SimplePermissionBuilder {
        private String id;
        private String name;
        private Set<String> actions;
        private Set<DataAccessConfig> dataAccesses;

        SimplePermissionBuilder() {
        }

        public SimplePermissionBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SimplePermissionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SimplePermissionBuilder actions(Set<String> actions) {
            this.actions = actions;
            return this;
        }

        public SimplePermissionBuilder dataAccesses(Set<DataAccessConfig> dataAccesses) {
            this.dataAccesses = dataAccesses;
            return this;
        }

        public SimplePermission build() {
            return new SimplePermission(this.id, this.name, this.actions, this.dataAccesses);
        }

        public String toString() {
            return "SimplePermission.SimplePermissionBuilder(id=" + this.id + ", name=" + this.name + ", actions=" + this.actions + ", dataAccesses=" + this.dataAccesses + ")";
        }
    }
}

