/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.token.redis;

import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.authorization.token.AllopatricLoginMode;
import org.hswebframework.web.authorization.token.AuthenticationUserToken;
import org.hswebframework.web.authorization.token.TokenState;
import org.hswebframework.web.authorization.token.UserToken;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.authorization.token.event.UserTokenChangedEvent;
import org.hswebframework.web.authorization.token.event.UserTokenCreatedEvent;
import org.hswebframework.web.authorization.token.event.UserTokenRemovedEvent;
import org.hswebframework.web.authorization.token.redis.SimpleUserToken;
import org.hswebframework.web.bean.FastBeanCopier;
import org.reactivestreams.Publisher;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveHashOperations;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.ReactiveSetOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class RedisUserTokenManager
implements UserTokenManager {
    private final ReactiveRedisOperations<Object, Object> operations;
    private final ReactiveHashOperations<Object, String, Object> userTokenStore;
    private final ReactiveSetOperations<Object, Object> userTokenMapping;
    private Map<String, SimpleUserToken> localCache = new ConcurrentHashMap<String, SimpleUserToken>();
    private FluxSink<UserToken> touchSink;
    private Map<String, AllopatricLoginMode> allopatricLoginModes = new HashMap<String, AllopatricLoginMode>();
    private AllopatricLoginMode allopatricLoginMode = AllopatricLoginMode.allow;
    private ApplicationEventPublisher eventPublisher;

    public RedisUserTokenManager(ReactiveRedisOperations<Object, Object> operations) {
        this.operations = operations;
        this.userTokenStore = operations.opsForHash();
        this.userTokenMapping = operations.opsForSet();
        this.operations.listenToChannel(new String[]{"_user_token_removed"}).subscribe(msg -> this.localCache.remove(String.valueOf(msg.getMessage())));
        Flux.create(sink -> {
            this.touchSink = sink;
        }).buffer((Publisher)Flux.interval((Duration)Duration.ofSeconds(10L)), HashSet::new).flatMap(list -> Flux.fromIterable((Iterable)list).flatMap(token -> {
            String key = this.getTokenRedisKey(token.getToken());
            return Mono.zip((Mono)this.userTokenStore.put((Object)key, (Object)"lastRequestTime", (Object)token.getLastRequestTime()), (Mono)this.operations.expire((Object)key, Duration.ofMillis(token.getMaxInactiveInterval()))).then();
        }).onErrorResume(err -> Mono.empty())).subscribe();
    }

    public RedisUserTokenManager(ReactiveRedisConnectionFactory connectionFactory) {
        this((ReactiveRedisOperations<Object, Object>)new ReactiveRedisTemplate(connectionFactory, RedisSerializationContext.newSerializationContext().key(RedisSerializer.string()).value(RedisSerializer.java()).hashKey(RedisSerializer.string()).hashValue(RedisSerializer.java()).build()));
    }

    private String getTokenRedisKey(String key) {
        return "user-token:".concat(key);
    }

    private String getUserRedisKey(String key) {
        return "user-token-user:".concat(key);
    }

    @Override
    public Mono<UserToken> getByToken(String token) {
        SimpleUserToken inCache = this.localCache.get(token);
        if (inCache != null && inCache.isNormal()) {
            return Mono.just((Object)inCache);
        }
        return this.userTokenStore.entries((Object)this.getTokenRedisKey(token)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).filter(map -> !map.isEmpty() && map.containsKey("token") && map.containsKey("userId")).map(SimpleUserToken::of).doOnNext(userToken -> this.localCache.put(userToken.getToken(), (SimpleUserToken)userToken)).cast(UserToken.class);
    }

    @Override
    public Flux<UserToken> getByUserId(String userId) {
        String redisKey = this.getUserRedisKey(userId);
        return this.userTokenMapping.members((Object)redisKey).map(String::valueOf).flatMap(token -> this.getByToken((String)token).switchIfEmpty(Mono.defer(() -> this.userTokenMapping.remove((Object)redisKey, new Object[]{token}).then(Mono.empty()))));
    }

    @Override
    public Mono<Boolean> userIsLoggedIn(String userId) {
        return this.getByUserId(userId).hasElements();
    }

    @Override
    public Mono<Boolean> tokenIsLoggedIn(String token) {
        return this.operations.hasKey((Object)this.getTokenRedisKey(token));
    }

    @Override
    public Mono<Integer> totalUser() {
        return this.operations.scan(ScanOptions.scanOptions().match("*user-token-user:*").build()).count().map(Long::intValue);
    }

    @Override
    public Mono<Integer> totalToken() {
        return this.operations.scan(ScanOptions.scanOptions().match("*user-token:*").build()).count().map(Long::intValue);
    }

    @Override
    public Flux<UserToken> allLoggedUser() {
        return this.operations.scan(ScanOptions.scanOptions().match("*user-token:*").build()).map(val -> String.valueOf(val).substring(11)).flatMap(this::getByToken);
    }

    @Override
    public Mono<Void> signOutByUserId(String userId) {
        return this.getByUserId(userId).flatMap(userToken -> this.operations.delete(new Object[]{this.getTokenRedisKey(userToken.getToken())}).then(this.onTokenRemoved((UserToken)userToken))).then(this.operations.delete(new Object[]{this.getUserRedisKey(userId)})).then();
    }

    @Override
    public Mono<Void> signOutByToken(String token) {
        return this.getByToken(token).flatMap(t -> this.operations.delete(new Object[]{this.getTokenRedisKey(t.getToken())}).then(this.userTokenMapping.remove((Object)this.getUserRedisKey(t.getUserId()), new Object[]{token})).then(this.onTokenRemoved((UserToken)t))).then();
    }

    @Override
    public Mono<Void> changeUserState(String userId, TokenState state) {
        return this.getByUserId(userId).flatMap(token -> this.changeTokenState(token.getToken(), state)).then();
    }

    @Override
    public Mono<Void> changeTokenState(String token, TokenState state) {
        return this.getByToken(token).flatMap(old -> {
            SimpleUserToken newToken = (SimpleUserToken)FastBeanCopier.copy((Object)old, (Object)new SimpleUserToken(), (String[])new String[0]);
            newToken.setState(state);
            return this.userTokenStore.put((Object)this.getTokenRedisKey(token), (Object)"state", (Object)state.getValue()).then(this.onTokenChanged((UserToken)old, newToken));
        });
    }

    private Mono<UserToken> signIn(String token, String type, String userId, long maxInactiveInterval, Consumer<Map<String, Object>> cacheBuilder) {
        return Mono.defer(() -> {
            Mono doSign = Mono.defer(() -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("token", token);
                map.put("type", type);
                map.put("userId", userId);
                map.put("maxInactiveInterval", maxInactiveInterval);
                map.put("state", TokenState.normal.getValue());
                map.put("signInTime", System.currentTimeMillis());
                map.put("lastRequestTime", System.currentTimeMillis());
                cacheBuilder.accept(map);
                String key = this.getTokenRedisKey(token);
                return this.userTokenStore.putAll((Object)key, map).then(Mono.defer(() -> {
                    if (maxInactiveInterval > 0L) {
                        return this.operations.expire((Object)key, Duration.ofMillis(maxInactiveInterval));
                    }
                    return Mono.empty();
                })).then(this.userTokenMapping.add((Object)this.getUserRedisKey(userId), new Object[]{token})).thenReturn((Object)SimpleUserToken.of(map));
            });
            AllopatricLoginMode mode = this.allopatricLoginModes.getOrDefault(type, this.allopatricLoginMode);
            if (mode == AllopatricLoginMode.deny) {
                return this.userIsLoggedIn(userId).flatMap(r -> {
                    if (r.booleanValue()) {
                        return Mono.error((Throwable)((Object)new AccessDenyException("error.logged_in_elsewhere", TokenState.deny.getValue())));
                    }
                    return doSign;
                });
            }
            if (mode == AllopatricLoginMode.offlineOther) {
                return this.getByUserId(userId).flatMap(userToken -> {
                    if (type.equals(userToken.getType())) {
                        return this.changeTokenState(userToken.getToken(), TokenState.offline);
                    }
                    return Mono.empty();
                }).then(doSign);
            }
            return doSign;
        }).flatMap(this::onUserTokenCreated);
    }

    @Override
    public Mono<UserToken> signIn(String token, String type, String userId, long maxInactiveInterval) {
        return this.signIn(token, type, userId, maxInactiveInterval, (Map<String, Object> ignore) -> {});
    }

    @Override
    public Mono<AuthenticationUserToken> signIn(String token, String type, String userId, long maxInactiveInterval, Authentication authentication) {
        return this.signIn(token, type, userId, maxInactiveInterval, (Map<String, Object> cache) -> cache.put("authentication", authentication)).cast(AuthenticationUserToken.class);
    }

    @Override
    public Mono<Void> touch(String token) {
        SimpleUserToken inCache = this.localCache.get(token);
        if (inCache != null && inCache.isNormal()) {
            inCache.setLastRequestTime(System.currentTimeMillis());
            if (inCache.getMaxInactiveInterval() > 0L) {
                this.touchSink.next((Object)inCache);
            }
            return Mono.empty();
        }
        return this.getByToken(token).flatMap(userToken -> {
            if (userToken.getMaxInactiveInterval() > 0L) {
                this.touchSink.next(userToken);
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<Void> checkExpiredToken() {
        return this.operations.scan(ScanOptions.scanOptions().match("*user-token-user:*").build()).map(String::valueOf).flatMap(key -> this.userTokenMapping.members(key).map(String::valueOf).flatMap(token -> this.operations.hasKey((Object)this.getTokenRedisKey((String)token)).flatMap(exists -> {
            if (!exists.booleanValue()) {
                return this.userTokenMapping.remove(key, new Object[]{token});
            }
            return Mono.empty();
        }))).then();
    }

    private Mono<Void> notifyTokenRemoved(String token) {
        return this.operations.convertAndSend("_user_token_removed", (Object)token).then();
    }

    private Mono<Void> onTokenRemoved(UserToken token) {
        this.localCache.remove(token.getToken());
        if (this.eventPublisher == null) {
            return this.notifyTokenRemoved(token.getToken());
        }
        return Mono.fromRunnable(() -> this.eventPublisher.publishEvent((ApplicationEvent)new UserTokenRemovedEvent(token))).then(this.notifyTokenRemoved(token.getToken()));
    }

    private Mono<Void> onTokenChanged(UserToken old, SimpleUserToken newToken) {
        this.localCache.put(newToken.getToken(), newToken);
        if (this.eventPublisher == null) {
            return this.notifyTokenRemoved(newToken.getToken());
        }
        return Mono.fromRunnable(() -> this.eventPublisher.publishEvent((ApplicationEvent)new UserTokenChangedEvent(old, newToken)));
    }

    private Mono<UserToken> onUserTokenCreated(SimpleUserToken token) {
        this.localCache.put(token.getToken(), token);
        if (this.eventPublisher == null) {
            return this.notifyTokenRemoved(token.getToken()).thenReturn((Object)token);
        }
        return Mono.fromRunnable(() -> this.eventPublisher.publishEvent((ApplicationEvent)new UserTokenCreatedEvent(token))).then(this.notifyTokenRemoved(token.getToken())).thenReturn((Object)token);
    }

    public void setLocalCache(Map<String, SimpleUserToken> localCache) {
        this.localCache = localCache;
    }

    public Map<String, AllopatricLoginMode> getAllopatricLoginModes() {
        return this.allopatricLoginModes;
    }

    public void setAllopatricLoginModes(Map<String, AllopatricLoginMode> allopatricLoginModes) {
        this.allopatricLoginModes = allopatricLoginModes;
    }

    public AllopatricLoginMode getAllopatricLoginMode() {
        return this.allopatricLoginMode;
    }

    public void setAllopatricLoginMode(AllopatricLoginMode allopatricLoginMode) {
        this.allopatricLoginMode = allopatricLoginMode;
    }

    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

