/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hswebframework.web.authorization.access.DataAccessConfig;
import org.hswebframework.web.authorization.access.FieldFilterDataAccessConfig;
import org.hswebframework.web.authorization.access.ScopeDataAccessConfig;

public interface Permission
extends Serializable {
    public static final String ACTION_QUERY = "query";
    public static final String ACTION_GET = "get";
    public static final String ACTION_ADD = "add";
    public static final String ACTION_SAVE = "save";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_IMPORT = "import";
    public static final String ACTION_EXPORT = "export";
    public static final String ACTION_DISABLE = "disable";
    public static final String ACTION_ENABLE = "enable";

    public String getId();

    public String getName();

    public Map<String, Object> getOptions();

    default public Optional<Object> getOption(String key) {
        return Optional.ofNullable(this.getOptions()).map(map -> map.get(key));
    }

    public Set<String> getActions();

    public Set<DataAccessConfig> getDataAccesses();

    default public Set<DataAccessConfig> getDataAccesses(String action) {
        return this.getDataAccesses().stream().filter(conf -> conf.getAction().equals(action)).collect(Collectors.toSet());
    }

    default public <T extends DataAccessConfig> Optional<T> findDataAccess(DataAccessPredicate<T> configPredicate) {
        return this.getDataAccesses().stream().filter(configPredicate).findFirst();
    }

    default public Optional<FieldFilterDataAccessConfig> findFieldFilter(String action) {
        return this.findDataAccess(conf -> conf instanceof FieldFilterDataAccessConfig && conf.getAction().equals(action));
    }

    default public Set<String> findDenyFields(String action) {
        return this.findFieldFilter(action).filter(conf -> "DENY_FIELDS".equals(conf.getType().getId())).map(FieldFilterDataAccessConfig::getFields).orElseGet(Collections::emptySet);
    }

    default public Set<Object> findScope(String action, String type, String scopeType) {
        return this.findScope(Permission.scope(action, type, scopeType));
    }

    default public Set<Object> findScope(DataAccessPredicate<ScopeDataAccessConfig> predicate) {
        return this.findDataAccess(predicate).map(ScopeDataAccessConfig::getScope).orElseGet(Collections::emptySet);
    }

    public static DataAccessPredicate<ScopeDataAccessConfig> scope(String action, String type, String scopeType) {
        Objects.requireNonNull(action, "action can not be null");
        Objects.requireNonNull(type, "type can not be null");
        Objects.requireNonNull(scopeType, "scopeType can not be null");
        return config -> config instanceof ScopeDataAccessConfig && action.equals(config.getAction()) && type.equals(config.getType()) && scopeType.equals(((ScopeDataAccessConfig)config).getScopeType());
    }

    public Permission copy();

    public Permission copy(Predicate<String> var1, Predicate<DataAccessConfig> var2);

    public static interface DataAccessPredicate<T extends DataAccessConfig>
    extends Predicate<DataAccessConfig> {
        @Override
        public boolean test(DataAccessConfig var1);

        @Override
        default public DataAccessPredicate<T> and(Predicate<? super DataAccessConfig> other) {
            return t -> this.test(t) && other.test(t);
        }

        @Override
        default public DataAccessPredicate<T> or(Predicate<? super DataAccessConfig> other) {
            return t -> this.test(t) || other.test(t);
        }
    }
}

