/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationSupplier;
import org.hswebframework.web.authorization.simple.SimpleAuthentication;

public final class AuthenticationHolder {
    private static final List<AuthenticationSupplier> suppliers = new ArrayList<AuthenticationSupplier>();
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();

    private static Optional<Authentication> get(Function<AuthenticationSupplier, Optional<Authentication>> function) {
        int size = suppliers.size();
        if (size == 0) {
            return Optional.empty();
        }
        if (size == 1) {
            return function.apply(suppliers.get(0));
        }
        SimpleAuthentication merge = new SimpleAuthentication();
        for (AuthenticationSupplier supplier : suppliers) {
            function.apply(supplier).ifPresent(merge::merge);
        }
        if (merge.getUser() == null) {
            return Optional.empty();
        }
        return Optional.of(merge);
    }

    public static Optional<Authentication> get() {
        return AuthenticationHolder.get(Supplier::get);
    }

    public static Optional<Authentication> get(String userId) {
        return AuthenticationHolder.get((AuthenticationSupplier supplier) -> supplier.get(userId));
    }

    public static void addSupplier(AuthenticationSupplier supplier) {
        lock.writeLock().lock();
        try {
            suppliers.add(supplier);
        }
        finally {
            lock.writeLock().unlock();
        }
    }
}

