/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.token.redis;

import java.util.Map;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.token.TokenState;
import org.hswebframework.web.authorization.token.UserToken;
import org.hswebframework.web.authorization.token.redis.SimpleAuthenticationUserToken;
import org.hswebframework.web.bean.FastBeanCopier;

public class SimpleUserToken
implements UserToken {
    private String userId;
    private String token;
    private long requestTimes;
    private long lastRequestTime;
    private long signInTime;
    private TokenState state;
    private String type;
    private long maxInactiveInterval;

    public static SimpleUserToken of(Map<String, Object> map) {
        Object authentication = map.get("authentication");
        if (authentication instanceof Authentication) {
            return (SimpleUserToken)FastBeanCopier.copy(map, (Object)new SimpleAuthenticationUserToken((Authentication)authentication), (String[])new String[0]);
        }
        return (SimpleUserToken)FastBeanCopier.copy(map, (Object)new SimpleUserToken(), (String[])new String[0]);
    }

    @Override
    public boolean isNormal() {
        if (this.checkExpired()) {
            this.setState(TokenState.expired);
            return false;
        }
        return UserToken.super.isNormal();
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public long getRequestTimes() {
        return this.requestTimes;
    }

    @Override
    public long getLastRequestTime() {
        return this.lastRequestTime;
    }

    @Override
    public long getSignInTime() {
        return this.signInTime;
    }

    @Override
    public TokenState getState() {
        return this.state;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public long getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setRequestTimes(long requestTimes) {
        this.requestTimes = requestTimes;
    }

    public void setLastRequestTime(long lastRequestTime) {
        this.lastRequestTime = lastRequestTime;
    }

    public void setSignInTime(long signInTime) {
        this.signInTime = signInTime;
    }

    public void setState(TokenState state) {
        this.state = state;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMaxInactiveInterval(long maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public String toString() {
        return "SimpleUserToken(userId=" + this.getUserId() + ", requestTimes=" + this.getRequestTimes() + ", lastRequestTime=" + this.getLastRequestTime() + ", signInTime=" + this.getSignInTime() + ", state=" + (Object)((Object)this.getState()) + ", type=" + this.getType() + ", maxInactiveInterval=" + this.getMaxInactiveInterval() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleUserToken)) {
            return false;
        }
        SimpleUserToken other = (SimpleUserToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleUserToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }
}

