/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.simple;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.web.authorization.Dimension;
import org.hswebframework.web.authorization.DimensionProvider;
import org.hswebframework.web.authorization.dimension.DimensionManager;
import org.hswebframework.web.authorization.dimension.DimensionUserBind;
import org.hswebframework.web.authorization.dimension.DimensionUserBindProvider;
import org.hswebframework.web.authorization.dimension.DimensionUserDetail;
import org.hswebframework.web.authorization.simple.SimpleDimensionType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class DefaultDimensionManager
implements DimensionManager {
    private final List<DimensionProvider> dimensionProviders = new CopyOnWriteArrayList<DimensionProvider>();
    private final List<DimensionUserBindProvider> bindProviders = new CopyOnWriteArrayList<DimensionUserBindProvider>();
    private final Mono<Map<String, DimensionProvider>> providerMapping = Flux.defer(() -> Flux.fromIterable(this.dimensionProviders)).flatMap(provider -> provider.getAllType().map(type -> Tuples.of((Object)type.getId(), (Object)provider))).collectMap(Tuple2::getT1, Tuple2::getT2);

    public void addProvider(DimensionProvider provider) {
        this.dimensionProviders.add(provider);
    }

    public void addBindProvider(DimensionUserBindProvider bindProvider) {
        this.bindProviders.add(bindProvider);
    }

    private Mono<Map<String, DimensionProvider>> providerMapping() {
        return this.providerMapping;
    }

    @Override
    public Flux<DimensionUserDetail> getUserDimension(Collection<String> userId) {
        return this.providerMapping().flatMapMany(providerMapping -> Flux.fromIterable(this.bindProviders).flatMap(provider -> provider.getDimensionBindInfo(userId)).groupBy(DimensionUserBind::getDimensionType).flatMap(group -> {
            String type = String.valueOf(group.key());
            Flux binds = group.cache();
            DimensionProvider provider = (DimensionProvider)providerMapping.get(type);
            if (null == provider) {
                return Mono.empty();
            }
            return binds.map(DimensionUserBind::getDimensionId).collect(Collectors.toSet()).flatMapMany(idList -> provider.getDimensionsById(SimpleDimensionType.of(type), (Collection<String>)idList)).collectMap(Dimension::getId, Function.identity()).flatMapMany(mapping -> binds.groupBy(DimensionUserBind::getUserId).flatMap(userGroup -> Mono.zip((Mono)Mono.just((Object)String.valueOf(userGroup.key())), (Mono)userGroup.handle((bind, sink) -> {
                Dimension dimension = (Dimension)mapping.get(bind.getDimensionId());
                if (dimension != null) {
                    sink.next((Object)dimension);
                }
            }).collectList(), DimensionUserDetail::of)));
        })).groupBy(DimensionUserDetail::getUserId).flatMap(group -> group.reduce(DimensionUserDetail::merge));
    }
}

