/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.token.redis;

import java.time.Duration;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.token.TokenAuthenticationManager;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import reactor.core.publisher.Mono;

public class RedisTokenAuthenticationManager
implements TokenAuthenticationManager {
    private final ReactiveRedisOperations<String, Authentication> operations;

    public RedisTokenAuthenticationManager(ReactiveRedisConnectionFactory connectionFactory) {
        this((ReactiveRedisOperations<String, Authentication>)new ReactiveRedisTemplate(connectionFactory, RedisSerializationContext.newSerializationContext().key(RedisSerializer.string()).value(RedisSerializer.java()).hashKey(RedisSerializer.string()).hashValue(RedisSerializer.java()).build()));
    }

    public RedisTokenAuthenticationManager(ReactiveRedisOperations<String, Authentication> operations) {
        this.operations = operations;
    }

    @Override
    public Mono<Authentication> getByToken(String token) {
        return this.operations.opsForValue().get((Object)("token-auth:" + token));
    }

    @Override
    public Mono<Void> removeToken(String token) {
        return this.operations.delete((Object[])new String[]{token}).then();
    }

    @Override
    public Mono<Void> putAuthentication(String token, Authentication auth, Duration ttl) {
        return ttl.isNegative() ? this.operations.opsForValue().set((Object)("token-auth:" + token), (Object)auth).then() : this.operations.opsForValue().set((Object)("token-auth:" + token), (Object)auth, ttl).then();
    }
}

