/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.token;

import java.io.Serializable;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.authorization.token.TokenState;

public interface UserToken
extends Serializable,
Comparable<UserToken> {
    public String getUserId();

    public String getToken();

    public long getRequestTimes();

    public long getLastRequestTime();

    public long getSignInTime();

    public TokenState getState();

    public String getType();

    public long getMaxInactiveInterval();

    default public boolean checkExpired() {
        long maxInactiveInterval = this.getMaxInactiveInterval();
        if (maxInactiveInterval > 0L) {
            return System.currentTimeMillis() - this.getLastRequestTime() > maxInactiveInterval;
        }
        return false;
    }

    default public boolean isNormal() {
        return this.getState() == TokenState.normal;
    }

    default public boolean isExpired() {
        return this.getState() == TokenState.expired;
    }

    default public boolean isOffline() {
        return this.getState() == TokenState.offline;
    }

    default public boolean isLock() {
        return this.getState() == TokenState.lock;
    }

    default public boolean isDeny() {
        return this.getState() == TokenState.deny;
    }

    default public boolean validate() {
        if (!this.isNormal()) {
            throw new UnAuthorizedException(this.getState());
        }
        return true;
    }

    @Override
    default public int compareTo(UserToken target) {
        if (target == null) {
            return 0;
        }
        return Long.compare(this.getSignInTime(), target.getSignInTime());
    }
}

