/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.twofactor.defaults;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.hswebframework.web.authorization.twofactor.TwoFactorToken;
import org.hswebframework.web.authorization.twofactor.TwoFactorTokenManager;

public class HashMapTwoFactorTokenManager
implements TwoFactorTokenManager {
    private Map<String, WeakReference<TwoFactorTokenInfo>> tokens = new ConcurrentHashMap<String, WeakReference<TwoFactorTokenInfo>>();

    private String createTokenInfoKey(String userId, String operation) {
        return userId + "_" + operation;
    }

    private TwoFactorTokenInfo getTokenInfo(String userId, String operation) {
        return Optional.ofNullable(this.tokens.get(this.createTokenInfoKey(userId, operation))).map(Reference::get).orElse(null);
    }

    @Override
    public TwoFactorToken getToken(final String userId, final String operation) {
        return new TwoFactorToken(){
            private static final long serialVersionUID = -5148037320548431456L;

            @Override
            public void generate(long timeout) {
                TwoFactorTokenInfo info = new TwoFactorTokenInfo();
                info.timeOut = timeout;
                HashMapTwoFactorTokenManager.this.tokens.put(HashMapTwoFactorTokenManager.this.createTokenInfoKey(userId, operation), new WeakReference<TwoFactorTokenInfo>(info));
            }

            @Override
            public boolean expired() {
                TwoFactorTokenInfo info = HashMapTwoFactorTokenManager.this.getTokenInfo(userId, operation);
                if (info == null) {
                    return true;
                }
                if (info.isExpire()) {
                    HashMapTwoFactorTokenManager.this.tokens.remove(HashMapTwoFactorTokenManager.this.createTokenInfoKey(userId, operation));
                    return true;
                }
                info.lastRequestTime = System.currentTimeMillis();
                return false;
            }
        };
    }

    private class TwoFactorTokenInfo
    implements Serializable {
        private static final long serialVersionUID = -5246224779564760241L;
        private volatile long lastRequestTime = System.currentTimeMillis();
        private long timeOut;

        private TwoFactorTokenInfo() {
        }

        private boolean isExpire() {
            return System.currentTimeMillis() - this.lastRequestTime >= this.timeOut;
        }
    }
}

