/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.simple;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationRequest;
import org.hswebframework.web.authorization.ReactiveAuthenticationManager;
import org.hswebframework.web.authorization.ReactiveAuthenticationManagerProvider;
import org.hswebframework.web.authorization.simple.SimpleAuthentication;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CompositeReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private List<ReactiveAuthenticationManagerProvider> providers;

    @Override
    public Mono<Authentication> authenticate(Mono<AuthenticationRequest> request) {
        return Flux.concat((Iterable)this.providers.stream().map(manager -> manager.authenticate(request).onErrorResume(err -> Mono.empty())).collect(Collectors.toList())).take(1L).next();
    }

    @Override
    public Mono<Authentication> getByUserId(String userId) {
        return Flux.fromStream(this.providers.stream().map(manager -> manager.getByUserId(userId).onErrorResume(err -> Mono.empty()))).flatMap(Function.identity()).reduceWith(SimpleAuthentication::of, Authentication::merge).filter(a -> a.getUser() != null);
    }

    public CompositeReactiveAuthenticationManager(List<ReactiveAuthenticationManagerProvider> providers) {
        this.providers = providers;
    }
}

