/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.ReactiveAuthenticationSupplier;
import org.hswebframework.web.authorization.simple.SimpleAuthentication;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ReactiveAuthenticationHolder {
    private static final List<ReactiveAuthenticationSupplier> suppliers = new ArrayList<ReactiveAuthenticationSupplier>();
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();

    private static Mono<Authentication> get(Function<ReactiveAuthenticationSupplier, Mono<Authentication>> function) {
        return Flux.concat((Iterable)suppliers.stream().map(function).collect(Collectors.toList())).reduceWith(SimpleAuthentication::new, Authentication::merge).filter(a -> a.getUser() != null);
    }

    public static Mono<Authentication> get() {
        return ReactiveAuthenticationHolder.get(Supplier::get);
    }

    public static Mono<Authentication> get(String userId) {
        return ReactiveAuthenticationHolder.get((ReactiveAuthenticationSupplier supplier) -> supplier.get(userId));
    }

    public static void addSupplier(ReactiveAuthenticationSupplier supplier) {
        lock.writeLock().lock();
        try {
            suppliers.add(supplier);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void setSupplier(ReactiveAuthenticationSupplier supplier) {
        lock.writeLock().lock();
        try {
            suppliers.clear();
            suppliers.add(supplier);
        }
        finally {
            lock.writeLock().unlock();
        }
    }
}

