/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.web.authorization.DimensionType;
import org.hswebframework.web.authorization.simple.SimpleDimension;

public interface Dimension
extends Serializable {
    public String getId();

    public String getName();

    public DimensionType getType();

    public Map<String, Object> getOptions();

    default public <T> Optional<T> getOption(String key) {
        return Optional.ofNullable(this.getOptions()).map(ops -> ops.get(key)).map(o -> o);
    }

    default public boolean typeIs(DimensionType type) {
        return this.getType() == type || this.getType().getId().equals(type.getId());
    }

    default public boolean typeIs(String type) {
        return this.getType().getId().equals(type);
    }

    public static Dimension of(String id, String name, DimensionType type) {
        return Dimension.of(id, name, type, null);
    }

    public static Dimension of(String id, String name, DimensionType type, Map<String, Object> options) {
        return SimpleDimension.of(id, name, type, options);
    }
}

