/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.twofactor.defaults;

import java.util.HashMap;
import java.util.Map;
import org.hswebframework.web.authorization.twofactor.TwoFactorValidator;
import org.hswebframework.web.authorization.twofactor.TwoFactorValidatorManager;
import org.hswebframework.web.authorization.twofactor.TwoFactorValidatorProvider;
import org.hswebframework.web.authorization.twofactor.defaults.UnsupportedTwoFactorValidator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class DefaultTwoFactorValidatorManager
implements TwoFactorValidatorManager,
BeanPostProcessor {
    private String defaultProvider = "totp";
    private Map<String, TwoFactorValidatorProvider> providers = new HashMap<String, TwoFactorValidatorProvider>();

    @Override
    public TwoFactorValidator getValidator(String userId, String operation, String provider) {
        TwoFactorValidatorProvider validatorProvider;
        if (provider == null) {
            provider = this.defaultProvider;
        }
        if ((validatorProvider = this.providers.get(provider)) == null) {
            return new UnsupportedTwoFactorValidator(provider);
        }
        return validatorProvider.createTwoFactorValidator(userId, operation);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof TwoFactorValidatorProvider) {
            TwoFactorValidatorProvider provider = (TwoFactorValidatorProvider)bean;
            this.providers.put(provider.getProvider(), provider);
            if (provider.getProvider().equalsIgnoreCase(this.defaultProvider)) {
                this.providers.put("default", provider);
            }
        }
        return bean;
    }

    public String getDefaultProvider() {
        return this.defaultProvider;
    }

    public void setDefaultProvider(String defaultProvider) {
        this.defaultProvider = defaultProvider;
    }
}

