/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.define;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.web.authorization.Dimension;
import org.hswebframework.web.authorization.annotation.Logical;
import org.hswebframework.web.authorization.define.DimensionDefinition;

public class DimensionsDefinition {
    private Set<DimensionDefinition> dimensions = new HashSet<DimensionDefinition>();
    private Logical logical = Logical.DEFAULT;

    public void addDimension(DimensionDefinition definition) {
        this.dimensions.add(definition);
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.dimensions);
    }

    public boolean hasDimension(Dimension dimension) {
        return this.dimensions.stream().anyMatch(def -> def.getTypeId().equals(dimension.getType().getId()) && def.hasDimension(dimension.getId()));
    }

    public boolean hasDimension(List<Dimension> dimensions) {
        if (this.logical == Logical.AND) {
            return dimensions.stream().allMatch(this::hasDimension);
        }
        return dimensions.stream().anyMatch(this::hasDimension);
    }

    public Set<DimensionDefinition> getDimensions() {
        return this.dimensions;
    }

    public Logical getLogical() {
        return this.logical;
    }

    public void setDimensions(Set<DimensionDefinition> dimensions) {
        this.dimensions = dimensions;
    }

    public void setLogical(Logical logical) {
        this.logical = logical;
    }
}

