/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.simple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.Dimension;
import org.hswebframework.web.authorization.Permission;
import org.hswebframework.web.authorization.User;

public class SimpleAuthentication
implements Authentication {
    private static final long serialVersionUID = -2898863220255336528L;
    private User user;
    private List<Permission> permissions = new ArrayList<Permission>();
    private List<Dimension> dimensions = new ArrayList<Dimension>();
    private Map<String, Serializable> attributes = new HashMap<String, Serializable>();

    public static Authentication of() {
        return new SimpleAuthentication();
    }

    @Override
    public <T extends Serializable> Optional<T> getAttribute(String name) {
        return Optional.ofNullable(this.attributes.get(name));
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return this.attributes;
    }

    @Override
    public SimpleAuthentication merge(Authentication authentication) {
        Map mePermissionGroup = this.permissions.stream().collect(Collectors.toMap(Permission::getId, Function.identity()));
        this.user = authentication.getUser();
        this.attributes.putAll(authentication.getAttributes());
        for (Permission permission : authentication.getPermissions()) {
            Permission me = (Permission)mePermissionGroup.get(permission.getId());
            if (me == null) {
                this.permissions.add(permission.copy());
                continue;
            }
            me.getActions().addAll(permission.getActions());
            me.getDataAccesses().addAll(permission.getDataAccesses());
        }
        for (Dimension dimension : authentication.getDimensions()) {
            if (this.getDimension(dimension.getType(), dimension.getId()).isPresent()) continue;
            this.dimensions.add(dimension);
        }
        return this;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public List<Permission> getPermissions() {
        return this.permissions;
    }

    @Override
    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    public void setDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
    }

    public void setAttributes(Map<String, Serializable> attributes) {
        this.attributes = attributes;
    }
}

