/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.twofactor.defaults;

import java.beans.ConstructorProperties;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hswebframework.web.authorization.twofactor.TwoFactorToken;
import org.hswebframework.web.authorization.twofactor.TwoFactorValidator;

public class DefaultTwoFactorValidator
implements TwoFactorValidator {
    private String provider;
    private Function<String, Boolean> validator;
    private Supplier<TwoFactorToken> tokenSupplier;

    @Override
    public boolean verify(String code, long timeout) {
        boolean success = this.validator.apply(code);
        if (success) {
            this.tokenSupplier.get().generate(timeout);
        }
        return success;
    }

    @Override
    public boolean expired() {
        return this.tokenSupplier.get().expired();
    }

    @ConstructorProperties(value={"provider", "validator", "tokenSupplier"})
    public DefaultTwoFactorValidator(String provider, Function<String, Boolean> validator, Supplier<TwoFactorToken> tokenSupplier) {
        this.provider = provider;
        this.validator = validator;
        this.tokenSupplier = tokenSupplier;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }
}

