/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hswebframework.web.ThreadLocalUtils;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationSupplier;

public final class AuthenticationHolder {
    private static final List<AuthenticationSupplier> suppliers = new ArrayList<AuthenticationSupplier>();
    private static final String CURRENT_USER_ID_KEY = Authentication.class.getName() + "_current_id";
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();

    private static Authentication get(Function<AuthenticationSupplier, Authentication> function) {
        lock.readLock().lock();
        try {
            Authentication authentication = suppliers.stream().map(function).filter(Objects::nonNull).findFirst().orElse(null);
            return authentication;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static Authentication get() {
        String currentId = (String)ThreadLocalUtils.get((String)CURRENT_USER_ID_KEY);
        if (currentId != null) {
            return AuthenticationHolder.get(currentId);
        }
        return AuthenticationHolder.get(Supplier::get);
    }

    public static Authentication get(String userId) {
        return AuthenticationHolder.get((AuthenticationSupplier supplier) -> supplier.get(userId));
    }

    public static void addSupplier(AuthenticationSupplier supplier) {
        lock.writeLock().lock();
        try {
            suppliers.add(supplier);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void setCurrentUserId(String id) {
        ThreadLocalUtils.put((String)CURRENT_USER_ID_KEY, (Object)id);
    }
}

