/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.token;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.web.ThreadLocalUtils;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationManager;
import org.hswebframework.web.authorization.AuthenticationSupplier;
import org.hswebframework.web.authorization.token.ThirdPartAuthenticationManager;
import org.hswebframework.web.authorization.token.UserToken;
import org.hswebframework.web.authorization.token.UserTokenHolder;
import org.springframework.beans.factory.annotation.Autowired;

public class UserTokenAuthenticationSupplier
implements AuthenticationSupplier {
    private AuthenticationManager defaultAuthenticationManager;
    private Map<String, ThirdPartAuthenticationManager> thirdPartAuthenticationManager = new HashMap<String, ThirdPartAuthenticationManager>();

    public UserTokenAuthenticationSupplier(AuthenticationManager defaultAuthenticationManager) {
        this.defaultAuthenticationManager = defaultAuthenticationManager;
    }

    @Autowired(required=false)
    public void setThirdPartAuthenticationManager(List<ThirdPartAuthenticationManager> thirdPartAuthenticationManager) {
        for (ThirdPartAuthenticationManager manager : thirdPartAuthenticationManager) {
            this.thirdPartAuthenticationManager.put(manager.getTokenType(), manager);
        }
    }

    @Override
    public Authentication get(String userId) {
        if (userId == null) {
            return null;
        }
        return this.get(this.defaultAuthenticationManager, userId);
    }

    protected Authentication get(ThirdPartAuthenticationManager authenticationManager, String userId) {
        if (null == userId) {
            return null;
        }
        if (null == authenticationManager) {
            return this.defaultAuthenticationManager.getByUserId(userId);
        }
        return authenticationManager.getByUserId(userId);
    }

    protected Authentication get(AuthenticationManager authenticationManager, String userId) {
        if (null == userId) {
            return null;
        }
        if (null == authenticationManager) {
            authenticationManager = this.defaultAuthenticationManager;
        }
        return authenticationManager.getByUserId(userId);
    }

    protected UserToken getCurrentUserToken() {
        return UserTokenHolder.currentToken();
    }

    @Override
    public Authentication get() {
        return (Authentication)ThreadLocalUtils.get((String)Authentication.class.getName(), () -> Optional.ofNullable(this.getCurrentUserToken()).filter(UserToken::validate).map(token -> this.get(this.thirdPartAuthenticationManager.get(token.getType()), token.getUserId())).orElse(null));
    }
}

