/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.token;

import java.util.concurrent.atomic.AtomicLong;
import org.hswebframework.web.authorization.token.TokenState;
import org.hswebframework.web.authorization.token.UserToken;

public class SimpleUserToken
implements UserToken {
    private static final long serialVersionUID = 1L;
    private String userId;
    private String token;
    private String type = "default";
    private volatile TokenState state;
    private AtomicLong requestTimesCounter = new AtomicLong(0L);
    private volatile long lastRequestTime = System.currentTimeMillis();
    private volatile long firstRequestTime = System.currentTimeMillis();
    private volatile long requestTimes;
    private long maxInactiveInterval;

    @Override
    public long getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(long maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public SimpleUserToken(String userId, String token) {
        this.userId = userId;
        this.token = token;
    }

    public SimpleUserToken() {
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public long getRequestTimes() {
        return this.requestTimesCounter.get();
    }

    @Override
    public long getLastRequestTime() {
        return this.lastRequestTime;
    }

    @Override
    public long getSignInTime() {
        return this.firstRequestTime;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public TokenState getState() {
        return this.state;
    }

    public void setState(TokenState state) {
        this.state = state;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setFirstRequestTime(long firstRequestTime) {
        this.firstRequestTime = firstRequestTime;
    }

    public void setLastRequestTime(long lastRequestTime) {
        this.lastRequestTime = lastRequestTime;
    }

    public void setRequestTimes(long requestTimes) {
        this.requestTimes = requestTimes;
        this.requestTimesCounter.set(requestTimes);
    }

    public void touch() {
        this.requestTimesCounter.addAndGet(1L);
        this.lastRequestTime = System.currentTimeMillis();
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SimpleUserToken copy() {
        SimpleUserToken userToken = new SimpleUserToken();
        userToken.firstRequestTime = this.firstRequestTime;
        userToken.lastRequestTime = this.lastRequestTime;
        userToken.requestTimesCounter = new AtomicLong(this.requestTimesCounter.get());
        userToken.token = this.token;
        userToken.userId = this.userId;
        userToken.state = this.state;
        userToken.maxInactiveInterval = this.maxInactiveInterval;
        userToken.type = this.type;
        return userToken;
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && this.hashCode() == obj.hashCode();
    }
}

