/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.listener.event;

import java.util.Optional;
import java.util.function.Function;
import org.hswebframework.web.authorization.listener.event.AuthorizationEvent;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractAuthorizationEvent
extends ApplicationEvent
implements AuthorizationEvent {
    private static final long serialVersionUID = -3027505108916079214L;
    protected String username;
    protected String password;
    private transient Function<String, Object> parameterGetter;

    public AbstractAuthorizationEvent(String username, String password, Function<String, Object> parameterGetter) {
        super((Object)(username + "/" + password));
        if (username == null || password == null || parameterGetter == null) {
            throw new NullPointerException();
        }
        this.username = username;
        this.password = password;
        this.parameterGetter = parameterGetter;
    }

    public <T> Optional<T> getParameter(String name) {
        return Optional.ofNullable(this.parameterGetter.apply(name));
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

