/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization;

import java.util.Objects;
import java.util.function.Predicate;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationUtils;
import org.hswebframework.web.authorization.exception.AccessDenyException;

@FunctionalInterface
public interface AuthenticationPredicate
extends Predicate<Authentication> {
    public static AuthenticationPredicate has(String permissionString) {
        return AuthenticationUtils.createPredicate(permissionString);
    }

    public static AuthenticationPredicate role(String role) {
        return autz -> autz.hasRole(role);
    }

    public static AuthenticationPredicate permission(String permissionId, String ... actions) {
        return autz -> autz.hasPermission(permissionId, actions);
    }

    default public AuthenticationPredicate and(String permissionString) {
        return this.and((Predicate)AuthenticationPredicate.has(permissionString));
    }

    default public AuthenticationPredicate or(String permissionString) {
        return this.or((Predicate)AuthenticationPredicate.has(permissionString));
    }

    default public AuthenticationPredicate and(Predicate<? super Authentication> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test((Authentication)t);
    }

    default public AuthenticationPredicate or(Predicate<? super Authentication> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test((Authentication)t);
    }

    default public boolean test() {
        return Authentication.current().map(this::test).orElse(false);
    }

    default public void assertHas() {
        if (!this.test()) {
            throw new AccessDenyException();
        }
    }

    default public void assertHas(Authentication authentication) {
        if (!this.test(authentication)) {
            throw new AccessDenyException();
        }
    }
}

