/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.token;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.authorization.token.AllopatricLoginMode;
import org.hswebframework.web.authorization.token.SimpleUserToken;
import org.hswebframework.web.authorization.token.TokenState;
import org.hswebframework.web.authorization.token.UserToken;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.authorization.token.event.UserTokenChangedEvent;
import org.hswebframework.web.authorization.token.event.UserTokenCreatedEvent;
import org.hswebframework.web.authorization.token.event.UserTokenRemovedEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class DefaultUserTokenManager
implements UserTokenManager {
    protected final ConcurrentMap<String, SimpleUserToken> tokenStorage;
    protected final ConcurrentMap<String, Set<String>> userStorage;
    private Map<String, AllopatricLoginMode> allopatricLoginModes = new HashMap<String, AllopatricLoginMode>();
    private AllopatricLoginMode allopatricLoginMode = AllopatricLoginMode.allow;
    private ApplicationEventPublisher eventPublisher;

    public DefaultUserTokenManager() {
        this(new ConcurrentHashMap<String, SimpleUserToken>(256));
    }

    public DefaultUserTokenManager(ConcurrentMap<String, SimpleUserToken> tokenStorage) {
        this(tokenStorage, new ConcurrentHashMap<String, Set<String>>());
    }

    public DefaultUserTokenManager(ConcurrentMap<String, SimpleUserToken> tokenStorage, ConcurrentMap<String, Set<String>> userStorage) {
        this.tokenStorage = tokenStorage;
        this.userStorage = userStorage;
    }

    @Autowired(required=false)
    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setAllopatricLoginMode(AllopatricLoginMode allopatricLoginMode) {
        this.allopatricLoginMode = allopatricLoginMode;
    }

    public AllopatricLoginMode getAllopatricLoginMode() {
        return this.allopatricLoginMode;
    }

    protected Set<String> getUserToken(String userId) {
        return this.userStorage.computeIfAbsent(userId, key -> new HashSet());
    }

    private SimpleUserToken checkTimeout(SimpleUserToken detail) {
        if (null == detail) {
            return null;
        }
        if (detail.getMaxInactiveInterval() <= 0L) {
            return detail;
        }
        if (System.currentTimeMillis() - detail.getLastRequestTime() > detail.getMaxInactiveInterval()) {
            this.changeTokenState(detail, TokenState.expired);
            return detail;
        }
        return detail;
    }

    @Override
    public SimpleUserToken getByToken(String token) {
        if (token == null) {
            return null;
        }
        return this.checkTimeout((SimpleUserToken)this.tokenStorage.get(token));
    }

    @Override
    public List<UserToken> getByUserId(String userId) {
        if (userId == null) {
            return new ArrayList<UserToken>();
        }
        Set<String> tokens = this.getUserToken(userId);
        if (tokens.isEmpty()) {
            this.userStorage.remove(userId);
            return new ArrayList<UserToken>();
        }
        return tokens.stream().map(this.tokenStorage::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public boolean userIsLoggedIn(String userId) {
        if (userId == null) {
            return false;
        }
        for (UserToken userToken : this.getByUserId(userId)) {
            if (!userToken.isNormal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean tokenIsLoggedIn(String token) {
        if (token == null) {
            return false;
        }
        SimpleUserToken userToken = this.getByToken(token);
        return userToken != null && !userToken.isExpired();
    }

    @Override
    public long totalUser() {
        return this.userStorage.size();
    }

    @Override
    public long totalToken() {
        return this.tokenStorage.size();
    }

    @Override
    public void allLoggedUser(Consumer<UserToken> consumer) {
        this.tokenStorage.values().forEach(consumer);
    }

    @Override
    public List<UserToken> allLoggedUser() {
        return new ArrayList<UserToken>(this.tokenStorage.values());
    }

    @Override
    public void signOutByUserId(String userId) {
        if (null == userId) {
            return;
        }
        Set<String> tokens = this.getUserToken(userId);
        tokens.forEach(token -> this.signOutByToken((String)token, false));
        tokens.clear();
        this.userStorage.remove(userId);
    }

    private void signOutByToken(String token, boolean removeUserToken) {
        if (token == null) {
            return;
        }
        SimpleUserToken tokenObject = (SimpleUserToken)this.tokenStorage.remove(token);
        if (tokenObject != null) {
            String userId = tokenObject.getUserId();
            if (removeUserToken) {
                Set<String> tokens = this.getUserToken(userId);
                if (!tokens.isEmpty()) {
                    tokens.remove(token);
                }
                if (tokens.isEmpty()) {
                    this.userStorage.remove(tokenObject.getUserId());
                }
            }
            this.publishEvent(new UserTokenRemovedEvent(tokenObject));
        }
    }

    @Override
    public void signOutByToken(String token) {
        this.signOutByToken(token, true);
    }

    protected void publishEvent(ApplicationEvent event) {
        if (null != this.eventPublisher) {
            this.eventPublisher.publishEvent(event);
        }
    }

    public void changeTokenState(SimpleUserToken userToken, TokenState state) {
        if (null != userToken) {
            SimpleUserToken copy = userToken.copy();
            userToken.setState(state);
            this.syncToken(userToken);
            this.publishEvent(new UserTokenChangedEvent(copy, userToken));
        }
    }

    @Override
    public void changeTokenState(String token, TokenState state) {
        this.changeTokenState(this.getByToken(token), state);
    }

    @Override
    public void changeUserState(String user, TokenState state) {
        this.getByUserId(user).forEach(token -> this.changeTokenState(token.getToken(), state));
    }

    @Override
    public UserToken signIn(String token, String type, String userId, long maxInactiveInterval) {
        SimpleUserToken detail = new SimpleUserToken(userId, token);
        detail.setType(type);
        detail.setMaxInactiveInterval(maxInactiveInterval);
        AllopatricLoginMode mode = this.allopatricLoginModes.getOrDefault(type, this.allopatricLoginMode);
        if (mode == AllopatricLoginMode.deny) {
            boolean hasAnotherToken = this.getByUserId(userId).stream().filter(userToken -> type.equals(userToken.getType())).map(SimpleUserToken.class::cast).peek(this::checkTimeout).anyMatch(UserToken::isNormal);
            if (hasAnotherToken) {
                throw new AccessDenyException("\u8be5\u7528\u6237\u5df2\u5728\u5176\u4ed6\u5730\u65b9\u767b\u9646");
            }
        } else if (mode == AllopatricLoginMode.offlineOther) {
            List<UserToken> oldToken = this.getByUserId(userId);
            for (UserToken userToken2 : oldToken) {
                if (!type.equals(userToken2.getType())) continue;
                this.changeTokenState(userToken2.getToken(), TokenState.offline);
            }
        }
        detail.setState(TokenState.normal);
        this.tokenStorage.put(token, detail);
        this.getUserToken(userId).add(token);
        this.publishEvent(new UserTokenCreatedEvent(detail));
        return detail;
    }

    @Override
    public void touch(String token) {
        SimpleUserToken userToken = (SimpleUserToken)this.tokenStorage.get(token);
        if (null != userToken) {
            userToken.touch();
            this.syncToken(userToken);
        }
    }

    @Override
    public void checkExpiredToken() {
        for (SimpleUserToken token : this.tokenStorage.values()) {
            if (token == null || !this.checkTimeout(token).isExpired()) continue;
            this.signOutByToken(token.getToken());
        }
    }

    protected void syncToken(UserToken userToken) {
    }

    public Map<String, AllopatricLoginMode> getAllopatricLoginModes() {
        return this.allopatricLoginModes;
    }

    public void setAllopatricLoginModes(Map<String, AllopatricLoginMode> allopatricLoginModes) {
        this.allopatricLoginModes = allopatricLoginModes;
    }
}

